/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.features;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ogcapi.APIDispatcher;
import org.geoserver.ogcapi.features.FeaturesResponse;
import org.geoserver.ogcapi.features.FeaturesTestSupport;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jsoup.nodes.Document;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.http.MediaType;

public class CollectionTest
extends FeaturesTestSupport {
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        FeatureTypeInfo basicPolygons = this.getCatalog().getFeatureTypeByName(this.getLayerId(MockData.BASIC_POLYGONS));
        basicPolygons.setOverridingServiceSRS(true);
        basicPolygons.getResponseSRS().addAll(Arrays.asList("3857", "32632"));
        this.getCatalog().save((ResourceInfo)basicPolygons);
    }

    @Test
    public void testCollectionJson() throws Exception {
        String roadSegments = this.getLayerId(MockData.ROAD_SEGMENTS);
        DocumentContext json = this.getAsJSONPath("ogc/features/collections/" + roadSegments, 200);
        Assert.assertEquals((Object)"cite:RoadSegments", (Object)json.read("$.id", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"RoadSegments", (Object)json.read("$.title", String.class, new Predicate[0]));
        Assert.assertEquals((double)-180.0, (double)((Double)json.read("$.extent.spatial.bbox[0][0]", Double.class, new Predicate[0])), (double)0.0);
        Assert.assertEquals((double)-90.0, (double)((Double)json.read("$.extent.spatial.bbox[0][1]", Double.class, new Predicate[0])), (double)0.0);
        Assert.assertEquals((double)180.0, (double)((Double)json.read("$.extent.spatial.bbox[0][2]", Double.class, new Predicate[0])), (double)0.0);
        Assert.assertEquals((double)90.0, (double)((Double)json.read("$.extent.spatial.bbox[0][3]", Double.class, new Predicate[0])), (double)0.0);
        Assert.assertEquals((Object)"http://www.opengis.net/def/crs/OGC/1.3/CRS84", (Object)json.read("$.extent.spatial.crs", String.class, new Predicate[0]));
        List<MediaType> formats = this.getFeaturesResponseFormats();
        MatcherAssert.assertThat((Object)((Integer)json.read("$.links.length()", Integer.class, new Predicate[0])), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(formats.size())));
        for (MediaType mediaType : formats) {
            List items = (List)json.read("$.links[?(@.type=='" + mediaType + "')]", List.class, new Predicate[0]);
            Map item = (Map)items.get(0);
            Assert.assertEquals((Object)("cite:RoadSegments items as " + mediaType), item.get("title"));
            Assert.assertEquals((Object)"items", item.get("rel"));
        }
        this.readSingle(json, "links[?(@.type=='application/gml+xml;version=3.2')]");
        MatcherAssert.assertThat((Object)((String)this.readSingle(json, "links[?(@.rel=='http://www.opengis.net/def/rel/ogc/1.0/queryables' && @.type=='application/schema+json')].href")), (Matcher)CoreMatchers.equalTo((Object)"http://localhost:8080/geoserver/ogc/features/collections/cite:RoadSegments/queryables?f=application%2Fschema%2Bjson"));
        List crs = (List)json.read("crs", new Predicate[0]);
        MatcherAssert.assertThat((Object)crs.size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(5000)));
        MatcherAssert.assertThat((Object)crs, (Matcher)Matchers.hasItems((Object[])new String[]{"http://www.opengis.net/def/crs/OGC/1.3/CRS84", "http://www.opengis.net/def/crs/EPSG/0/4326", "http://www.opengis.net/def/crs/EPSG/0/3857"}));
        crs.remove("http://www.opengis.net/def/crs/OGC/1.3/CRS84");
        for (String c : crs) {
            MatcherAssert.assertThat((Object)c, (Matcher)Matchers.startsWith((String)"http://www.opengis.net/def/crs/EPSG/0"));
            Assert.assertTrue((String)(c + " is not using a numeric code"), (boolean)c.substring("http://www.opengis.net/def/crs/EPSG/0/".length()).matches("\\d+"));
        }
        String string = (String)json.read("storageCrs", new Predicate[0]);
        Assert.assertEquals((Object)"http://www.opengis.net/def/crs/OGC/1.3/CRS84", (Object)string);
    }

    @Test
    public void testCollectionJsonCustomCRSList() throws Exception {
        String roadSegments = this.getLayerId(MockData.BASIC_POLYGONS);
        DocumentContext json = this.getAsJSONPath("ogc/features/collections/" + roadSegments, 200);
        Assert.assertEquals((Object)"cite:BasicPolygons", (Object)json.read("$.id", String.class, new Predicate[0]));
        List crs = (List)json.read("crs", new Predicate[0]);
        MatcherAssert.assertThat((Object)crs, (Matcher)Matchers.contains((Object[])new String[]{"http://www.opengis.net/def/crs/OGC/1.3/CRS84", "http://www.opengis.net/def/crs/EPSG/0/3857", "http://www.opengis.net/def/crs/EPSG/0/32632"}));
    }

    private List<MediaType> getFeaturesResponseFormats() {
        return ((APIDispatcher)GeoServerExtensions.bean(APIDispatcher.class, (ApplicationContext)GeoServerSystemTestSupport.applicationContext)).getProducibleMediaTypes(FeaturesResponse.class, true);
    }

    @Test
    public void testCollectionVirtualWorkspace() throws Exception {
        String roadSegments = MockData.ROAD_SEGMENTS.getLocalPart();
        DocumentContext json = this.getAsJSONPath("cite/ogc/features/collections/" + roadSegments, 200);
        Assert.assertEquals((Object)"RoadSegments", (Object)json.read("$.id", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"RoadSegments", (Object)json.read("$.title", String.class, new Predicate[0]));
        List<MediaType> formats = this.getFeaturesResponseFormats();
        MatcherAssert.assertThat((Object)((Integer)json.read("$.links.length()", Integer.class, new Predicate[0])), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(formats.size())));
        for (MediaType format : formats) {
            List items = (List)json.read("$.links[?(@.type=='" + format + "')]", List.class, new Predicate[0]);
            Map item = (Map)items.get(0);
            Assert.assertEquals((Object)("RoadSegments items as " + format), item.get("title"));
            Assert.assertEquals((Object)"items", item.get("rel"));
        }
        this.readSingle(json, "$.links[?(@.type=='application/gml+xml;version=3.2')]");
    }

    @Test
    @Ignore
    public void testCollectionXML() throws Exception {
        org.w3c.dom.Document dom = this.getAsDOM("ogc/features/collections/" + this.getLayerId(MockData.ROAD_SEGMENTS) + "?f=application/xml");
        this.print(dom);
        String expected = "http://localhost:8080/geoserver/ogc/features/collections/cite%3ARoadSegments/items?f=application%2Fjson";
        XMLAssert.assertXpathEvaluatesTo((String)expected, (String)"//wfs:Collection[wfs:id='cite:RoadSegments']/atom:link[@atom:type='application/json']/@atom:href", (org.w3c.dom.Document)dom);
    }

    @Test
    public void testCollectionYaml() throws Exception {
        this.getAsString("ogc/features/collections/" + this.getLayerId(MockData.ROAD_SEGMENTS) + "?f=application/x-yaml");
    }

    @Test
    public void testQueryables() throws Exception {
        String roadSegments = MockData.ROAD_SEGMENTS.getLocalPart();
        DocumentContext json = this.getAsJSONPath("cite/ogc/features/collections/" + roadSegments + "/queryables", 200);
        MatcherAssert.assertThat((Object)((String)json.read("properties.the_geom.$ref", new Predicate[0])), (Matcher)CoreMatchers.equalTo((Object)"https://geojson.org/schema/MultiLineString.json"));
        MatcherAssert.assertThat((Object)((String)json.read("properties.FID.type", new Predicate[0])), (Matcher)CoreMatchers.equalTo((Object)"string"));
        MatcherAssert.assertThat((Object)((String)json.read("properties.NAME.type", new Predicate[0])), (Matcher)CoreMatchers.equalTo((Object)"string"));
    }

    @Test
    public void testQueryablesHTML() throws Exception {
        String roadSegments = MockData.ROAD_SEGMENTS.getLocalPart();
        Document document = this.getAsJSoup("cite/ogc/features/collections/" + roadSegments + "/queryables?f=html");
        Assert.assertEquals((Object)"the_geom: MultiLineString", (Object)document.select("#queryables li:eq(0)").text());
    }
}

