/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.dggs;

import io.swagger.v3.oas.models.OpenAPI;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import net.opengis.wfs20.Wfs20Factory;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.data.DimensionFilterBuilder;
import org.geoserver.ogcapi.APIException;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ogcapi.APIService;
import org.geoserver.ogcapi.ConformanceDocument;
import org.geoserver.ogcapi.DateTimeList;
import org.geoserver.ogcapi.DefaultContentType;
import org.geoserver.ogcapi.HTMLResponseBody;
import org.geoserver.ogcapi.Link;
import org.geoserver.ogcapi.PropertiesParser;
import org.geoserver.ogcapi.v1.dggs.CollectionDocument;
import org.geoserver.ogcapi.v1.dggs.CollectionsDocument;
import org.geoserver.ogcapi.v1.dggs.DGGSAPIBuilder;
import org.geoserver.ogcapi.v1.dggs.DGGSGeometryFilterParser;
import org.geoserver.ogcapi.v1.dggs.DGGSInfo;
import org.geoserver.ogcapi.v1.dggs.DGGSLandingPage;
import org.geoserver.ogcapi.v1.features.FeaturesGetFeature;
import org.geoserver.ogcapi.v1.features.FeaturesResponse;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geoserver.wfs.request.GetFeatureRequest;
import org.geoserver.wfs.request.Query;
import org.geoserver.wms.WMS;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.dggs.DGGSInstance;
import org.geotools.dggs.Zone;
import org.geotools.dggs.gstore.DGGSStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.logging.Logging;
import org.geotools.xsd.EMFUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@APIService(service="DGGS", version="1.0.1", landingPage="ogc/dggs/v1", serviceClass=DGGSInfo.class)
@RequestMapping(path={"ogc/dggs/v1"})
public class DGGSService {
    static final Logger LOGGER = Logging.getLogger(DGGSService.class);
    static final FilterFactory FF = CommonFactoryFinder.getFilterFactory();
    public static final String CORE = "http://www.opengis.net/spec/ogcapi-dggs-1/1.0/conf/core";
    private final GeoServer gs;
    private static final String DISPLAY_NAME = "DGGS";
    private final WMS wms;
    DimensionFilterBuilder fb = new DimensionFilterBuilder(FF);

    public DGGSService(GeoServer gs, WMS wms) {
        this.gs = gs;
        this.wms = wms;
    }

    private Catalog getCatalog() {
        return this.gs.getCatalog();
    }

    public DGGSInfo getService() {
        return (DGGSInfo)this.gs.getService(DGGSInfo.class);
    }

    public DGGSInfo getServiceInfo() {
        return this.getService();
    }

    @GetMapping(name="getLandingPage")
    @ResponseBody
    @HTMLResponseBody(templateName="landingPage.ftl", fileName="landingPage.html")
    public DGGSLandingPage getLandingPage() {
        return new DGGSLandingPage(this.getService(), this.getCatalog(), "ogc/dggs/v1");
    }

    @GetMapping(path={"conformance"}, name="getConformanceDeclaration")
    @ResponseBody
    @HTMLResponseBody(templateName="conformance.ftl", fileName="conformance.html")
    public ConformanceDocument conformance() {
        List<String> classes = Arrays.asList(CORE);
        return new ConformanceDocument(DISPLAY_NAME, classes);
    }

    @GetMapping(path={"openapi", "openapi.json", "openapi.yaml"}, name="getApi", produces={"application/vnd.oai.openapi+json;version=3.0", "application/yaml", "text/xml"})
    @ResponseBody
    @HTMLResponseBody(templateName="api.ftl", fileName="api.html")
    public OpenAPI api() throws IOException {
        return new DGGSAPIBuilder().build(this.getService());
    }

    @GetMapping(path={"collections"}, name="getCollections")
    @ResponseBody
    @HTMLResponseBody(templateName="collections.ftl", fileName="collections.html")
    public CollectionsDocument getCollections() {
        return new CollectionsDocument(this.gs);
    }

    @GetMapping(path={"collections/{collectionId}"}, name="describeCollection")
    @ResponseBody
    @HTMLResponseBody(templateName="collection.ftl", fileName="collection.html")
    public CollectionDocument collection(@PathVariable(name="collectionId") String collectionId) throws IOException {
        FeatureTypeInfo ft = this.getFeatureType(collectionId);
        CollectionDocument collection = new CollectionDocument(this.gs, ft);
        return collection;
    }

    protected FeatureTypeInfo getFeatureType(String collectionId) throws IOException {
        FeatureTypeInfo featureType = this.getCatalog().getFeatureTypeByName(collectionId);
        if (featureType == null) {
            throw new ServiceException("Unknown collection " + collectionId, "InvalidParameterValue", "collectionId");
        }
        if (!DGGSService.isDGGSType(featureType)) {
            throw new ServiceException("Collection " + collectionId + " is not backed by a DGGS data source", "InvalidParameterValue", "collectionId");
        }
        return featureType;
    }

    public static boolean isDGGSType(FeatureTypeInfo featureType) {
        try {
            return featureType.getStore().getDataStore(null) instanceof DGGSStore;
        }
        catch (Exception e) {
            LOGGER.log(Level.FINER, "Failed to grab store for " + featureType);
            return false;
        }
    }

    @GetMapping(path={"collections/{collectionId}/zones"}, name="getZones")
    @ResponseBody
    @DefaultContentType(value="application/geo+json")
    public FeaturesResponse zones(@PathVariable(name="collectionId") String collectionId, @RequestParam(name="startIndex", required=false, defaultValue="0") BigInteger startIndex, @RequestParam(name="limit", required=false) BigInteger limit, @RequestParam(name="resolution", required=false, defaultValue="0") Integer resolution, @RequestParam(name="datetime", required=false) DateTimeList datetime, @RequestParam(name="bbox", required=false) String bbox, @RequestParam(name="geom", required=false) String wkt, @RequestParam(name="zones", required=false) String zones, @RequestParam(name="properties", required=false) String properties, @RequestParam(name="f", required=false, defaultValue="application/geo+json") String format) throws Exception {
        DGGSGeometryFilterParser geometryParser = new DGGSGeometryFilterParser(FF, this.getDGGSInstance(collectionId));
        geometryParser.setBBOX(bbox);
        geometryParser.setGeometry(wkt);
        geometryParser.setZoneIds(zones, resolution);
        return this.runGetFeature(collectionId, datetime, properties, startIndex, limit, format, request -> {
            if (resolution != null) {
                request.setViewParams(Collections.singletonList(Collections.singletonMap("res", String.valueOf(resolution))));
                PropertyIsEqualTo resolutionFilter = FF.equals((Expression)FF.property("resolution"), (Expression)FF.literal((Object)resolution));
                this.mixFilter((GetFeatureRequest)request, (Filter)resolutionFilter);
                Filter geometryFilter = geometryParser.getFilter();
                if (geometryFilter != null && geometryFilter != Filter.INCLUDE) {
                    this.mixFilter((GetFeatureRequest)request, geometryFilter);
                }
            }
        }, collectionName -> "ogc/dggs/collections/" + ResponseUtils.urlEncode((String)collectionName, (char[])new char[0]) + "/zones");
    }

    void mixFilter(GetFeatureRequest request, Filter mix) {
        Query query = (Query)request.getQueries().get(0);
        Filter filter = query.getFilter();
        if (filter == Filter.INCLUDE || filter == null) {
            query.setFilter(mix);
        } else {
            query.setFilter((Filter)FF.and(mix, filter));
        }
    }

    private void customizeByFormat(Query query, FeatureTypeInfo ft, String format) throws IOException {
        if ("application/dggs+json".equals(format) && query.getPropertyNames().isEmpty()) {
            SimpleFeatureType schema = (SimpleFeatureType)ft.getFeatureType();
            ArrayList<QName> attributes = new ArrayList<QName>();
            for (AttributeDescriptor ad : schema.getAttributeDescriptors()) {
                if (Boolean.TRUE.equals(ad.getUserData().get("dggsInstrisic"))) continue;
                attributes.add(new QName(ad.getLocalName()));
            }
            EMFUtils.set((EObject)query.getAdaptee(), (String)"propertyNames", attributes);
        }
    }

    @GetMapping(path={"collections/{collectionId}/neighbors"}, name="getNeighbors")
    @ResponseBody
    @DefaultContentType(value="application/geo+json")
    public FeaturesResponse neighbors(@PathVariable(name="collectionId") String collectionId, @RequestParam(name="zone_id") String zoneId, @RequestParam(name="properties", required=false) String properties, @RequestParam(name="startIndex", required=false, defaultValue="0") BigInteger startIndex, @RequestParam(name="limit", required=false) BigInteger limit, @RequestParam(name="datetime", required=false) DateTimeList datetime, @RequestParam(name="distance", required=false, defaultValue="1") int distance, @RequestParam(name="f", required=false, defaultValue="application/geo+json") String format) throws Exception {
        if (distance <= 0) {
            throw new APIException("InvalidParameterValue", "Neighboring distance must be positive", HttpStatus.BAD_REQUEST);
        }
        int maxNeighborDistance = this.getService().getMaxNeighborDistance();
        if (maxNeighborDistance > 0 && distance > maxNeighborDistance) {
            throw new APIException("InvalidParameterValue", "Neighboring distance exceeds maximum value: " + maxNeighborDistance, HttpStatus.BAD_REQUEST);
        }
        PropertyIsEqualTo neighborFilter = FF.equals((Expression)FF.function("neighbor", new Expression[]{FF.property("zoneId"), FF.literal((Object)zoneId), FF.literal(distance)}), (Expression)FF.literal(true));
        return this.runGetFeature(collectionId, datetime, properties, startIndex, limit, format, request -> this.mixFilter((GetFeatureRequest)request, (Filter)neighborFilter), collectionName -> "ogc/dggs/collections/" + ResponseUtils.urlEncode((String)collectionName, (char[])new char[0]) + "/neighbors");
    }

    @GetMapping(path={"collections/{collectionId}/zone"}, name="getZone")
    @ResponseBody
    @DefaultContentType(value="application/geo+json")
    @HTMLResponseBody(templateName="zone.ftl", fileName="zone.html")
    public FeaturesResponse zone(@PathVariable(name="collectionId") String collectionId, @RequestParam(name="zone_id") String zoneId, @RequestParam(name="datetime", required=false) DateTimeList datetime, @RequestParam(name="properties", required=false) String properties, @RequestParam(name="f", required=false, defaultValue="application/geo+json") String format) throws Exception {
        FeaturesResponse response = this.runGetFeature(collectionId, datetime, properties, null, null, format, request -> this.mixFilter((GetFeatureRequest)request, (Filter)FF.equals((Expression)FF.property("zoneId"), (Expression)FF.literal((Object)zoneId))), collectionName -> "ogc/dggs/collections/" + ResponseUtils.urlEncode((String)collectionName, (char[])new char[0]) + "/zones/" + ResponseUtils.urlEncode((String)zoneId, (char[])new char[0]));
        response.addLink(this.getParentsLink(collectionId, zoneId));
        response.addLink(this.getChildrenLink(collectionId, zoneId));
        response.addLink(this.getNeighborLink(collectionId, zoneId));
        return response;
    }

    private Link getParentsLink(String collectionId, String zoneId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("f", "text/html");
        params.put("zone_id", zoneId);
        this.reflectDatetime(params);
        String url = ResponseUtils.buildURL((String)APIRequestInfo.get().getBaseURL(), (String)("ogc/dggs/collections/" + ResponseUtils.urlEncode((String)collectionId, (char[])new char[0]) + "/parents"), params, (URLMangler.URLType)URLMangler.URLType.SERVICE);
        Link link = new Link(url, "parents", "text/html", "Zone parents");
        link.setClassification("parents");
        return link;
    }

    private void reflectDatetime(Map<String, String> params) {
        APIRequestInfo requestInfo = APIRequestInfo.get();
        String datetime = requestInfo.getRequest().getParameter("datetime");
        if (datetime != null) {
            params.put("datetime", datetime);
        }
    }

    private Link getChildrenLink(String collectionId, String zoneId) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("f", "text/html");
        params.put("zone_id", zoneId);
        this.reflectDatetime(params);
        params.put("resolution", String.valueOf(this.getDGGSInstance(collectionId).getZone(zoneId).getResolution() + 1));
        String url = ResponseUtils.buildURL((String)APIRequestInfo.get().getBaseURL(), (String)("ogc/dggs/collections/" + ResponseUtils.urlEncode((String)collectionId, (char[])new char[0]) + "/children"), params, (URLMangler.URLType)URLMangler.URLType.SERVICE);
        Link link = new Link(url, "children", "text/html", "Zone immediate children");
        link.setClassification("children");
        return link;
    }

    private Link getNeighborLink(String collectionId, String zoneId) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("f", "text/html");
        params.put("zone_id", zoneId);
        params.put("distance", "1");
        this.reflectDatetime(params);
        String url = ResponseUtils.buildURL((String)APIRequestInfo.get().getBaseURL(), (String)("ogc/dggs/collections/" + ResponseUtils.urlEncode((String)collectionId, (char[])new char[0]) + "/neighbors"), params, (URLMangler.URLType)URLMangler.URLType.SERVICE);
        Link link = new Link(url, "neighbors", "text/html", "Zone immediate neighbors");
        link.setClassification("neighbors");
        return link;
    }

    DGGSInstance getDGGSInstance(String collectionId) throws IOException {
        FeatureTypeInfo featureType = this.getFeatureType(collectionId);
        DGGSStore dggsStore = (DGGSStore)featureType.getStore().getDataStore(null);
        return dggsStore.getDGGSFeatureSource(featureType.getNativeName()).getDGGS();
    }

    @GetMapping(path={"collections/{collectionId}/children"}, name="getChildren")
    @ResponseBody
    @DefaultContentType(value="application/geo+json")
    public FeaturesResponse children(@PathVariable(name="collectionId") String collectionId, @RequestParam(name="zone_id") String zoneId, @RequestParam(name="properties", required=false) String properties, @RequestParam(name="startIndex", required=false, defaultValue="0") BigInteger startIndex, @RequestParam(name="limit", required=false) BigInteger limit, @RequestParam(name="resolution", required=false) Integer resolution, @RequestParam(name="datetime", required=false) DateTimeList datetime, @RequestParam(name="f", required=false, defaultValue="application/geo+json") String format) throws Exception {
        PropertyIsEqualTo childFilter = FF.equals((Expression)FF.function("children", new Expression[]{FF.property("zoneId"), FF.literal((Object)zoneId), FF.literal((Object)resolution)}), (Expression)FF.literal(true));
        return this.runGetFeature(collectionId, datetime, properties, startIndex, limit, format, request -> this.mixFilter((GetFeatureRequest)request, (Filter)childFilter), collectionName -> "ogc/dggs/collections/" + ResponseUtils.urlEncode((String)collectionName, (char[])new char[0]) + "/children");
    }

    @GetMapping(path={"collections/{collectionId}/parents"}, name="getParents")
    @ResponseBody
    @DefaultContentType(value="application/geo+json")
    public FeaturesResponse parents(@PathVariable(name="collectionId") String collectionId, @RequestParam(name="zone_id") String zoneId, @RequestParam(name="datetime", required=false) DateTimeList datetime, @RequestParam(name="properties", required=false) String properties, @RequestParam(name="startIndex", required=false, defaultValue="0") BigInteger startIndex, @RequestParam(name="limit", required=false) BigInteger limit, @RequestParam(name="f", required=false, defaultValue="application/geo+json") String format) throws Exception {
        PropertyIsEqualTo parentFilter = FF.equals((Expression)FF.function("parents", new Expression[]{FF.property("zoneId"), FF.literal((Object)zoneId)}), (Expression)FF.literal(true));
        return this.runGetFeature(collectionId, datetime, properties, startIndex, limit, format, request -> this.mixFilter((GetFeatureRequest)request, (Filter)parentFilter), collectionName -> "ogc/dggs/collections/" + ResponseUtils.urlEncode((String)collectionName, (char[])new char[0]) + "/parents");
    }

    public FeaturesResponse runGetFeature(String collectionId, DateTimeList dateTimeList, String properties, BigInteger startIndex, BigInteger limit, String format, Consumer<GetFeatureRequest> requestCustomizer, final Function<String, String> pathBuilder) throws IOException {
        FeatureTypeInfo ft = this.getFeatureType(collectionId);
        GetFeatureRequest request = GetFeatureRequest.adapt((Object)Wfs20Factory.eINSTANCE.createGetFeatureType());
        Query query = request.createQuery();
        query.setTypeNames(Arrays.asList(new QName(ft.getNamespace().getURI(), ft.getName())));
        if (properties != null) {
            List propertyNames = new PropertiesParser((ResourceInfo)ft).parse(properties);
            query.setPropertyNames(propertyNames);
        }
        this.customizeByFormat(query, ft, format);
        query.setFilter(this.buildDateTimeFilter(ft, dateTimeList));
        request.setStartIndex(startIndex);
        request.setMaxFeatures(this.getLimit(limit));
        request.setBaseUrl(APIRequestInfo.get().getBaseURL());
        request.getAdaptedQueries().add(query.getAdaptee());
        requestCustomizer.accept(request);
        FeaturesGetFeature gf = new FeaturesGetFeature((WFSInfo)this.gs.getService(WFSInfo.class), this.getCatalog()){

            protected String getItemsPath(String collectionName) {
                return (String)pathBuilder.apply(collectionName);
            }
        };
        gf.setFilterFactory(FF);
        FeatureCollectionResponse response = gf.run(request);
        return new FeaturesResponse(request.getAdaptee(), response);
    }

    protected Filter buildDateTimeFilter(FeatureTypeInfo ft, DateTimeList dateTimeList) throws IOException {
        DimensionInfo time = (DimensionInfo)ft.getMetadata().get("time", DimensionInfo.class);
        if (time == null) {
            return Filter.INCLUDE;
        }
        if (dateTimeList == null || dateTimeList.isEmpty()) {
            dateTimeList = new DateTimeList();
            dateTimeList.add(this.wms.getDefaultTime((ResourceInfo)ft));
        }
        return this.wms.getDimensionFilter((List)dateTimeList, null, ft, null);
    }

    private BigInteger getLimit(BigInteger limit) {
        int max = this.getService().getMaxNumberOfZonesForPreview();
        if (limit == null) {
            return BigInteger.valueOf(max);
        }
        return limit;
    }

    @GetMapping(path={"collections/{collectionId}/point"}, name="point")
    @ResponseBody
    @DefaultContentType(value="application/geo+json")
    @HTMLResponseBody(templateName="zone.ftl", fileName="zone.html")
    public FeaturesResponse point(@PathVariable(name="collectionId") String collectionId, @RequestParam(name="point") String pointSpec, @RequestParam(name="resolution") int resolution, @RequestParam(name="properties", required=false) String properties, @RequestParam(name="datetime", required=false) DateTimeList datetime, @RequestParam(name="f", required=false, defaultValue="application/geo+json") String format) throws Exception {
        Point point = this.getPoint(pointSpec);
        DGGSInstance dggs = this.getDGGSInstance(collectionId);
        Zone zone = dggs.point(point, resolution);
        String zoneId = zone.getId();
        FeaturesResponse response = this.runGetFeature(collectionId, datetime, properties, null, null, format, request -> this.mixFilter((GetFeatureRequest)request, (Filter)FF.equals((Expression)FF.property("zoneId"), (Expression)FF.literal((Object)zone.getId()))), collectionName -> "ogc/dggs/collections/" + ResponseUtils.urlEncode((String)collectionName, (char[])new char[0]) + "/zones/" + ResponseUtils.urlEncode((String)zoneId, (char[])new char[0]));
        response.addLink(this.getParentsLink(collectionId, zoneId));
        response.addLink(this.getChildrenLink(collectionId, zoneId));
        response.addLink(this.getNeighborLink(collectionId, zoneId));
        return response;
    }

    @GetMapping(path={"collections/{collectionId}/polygon"}, name="polygon")
    @ResponseBody
    @DefaultContentType(value="application/geo+json")
    public FeaturesResponse polygon(@PathVariable(name="collectionId") String collectionId, @RequestParam(name="polygon") String polygonWKT, @RequestParam(name="resolution") int resolution, @RequestParam(name="properties", required=false) String properties, @RequestParam(name="startIndex", required=false, defaultValue="0") BigInteger startIndex, @RequestParam(name="limit", required=false) BigInteger limit, @RequestParam(name="compact", required=true, defaultValue="true") boolean compact, @RequestParam(name="datetime", required=false) DateTimeList datetime, @RequestParam(name="f", required=false, defaultValue="application/geo+json") String format) throws Exception {
        Polygon polygon = this.getPolygon(polygonWKT);
        PropertyIsEqualTo polygonFilter = FF.equals((Expression)FF.function("dggsPolygon", new Expression[]{FF.property("zoneId"), FF.literal((Object)polygon), FF.literal(resolution), FF.literal(compact)}), (Expression)FF.literal((Object)"true"));
        FeaturesResponse response = this.runGetFeature(collectionId, datetime, properties, startIndex, limit, format, request -> {
            Query query = (Query)request.getQueries().get(0);
            query.setFilter((Filter)polygonFilter);
        }, collectionName -> "ogc/dggs/collections/" + ResponseUtils.urlEncode((String)collectionName, (char[])new char[0]) + "/polygon/");
        return response;
    }

    public Polygon getPolygon(String polygonWKT) {
        try {
            Polygon polygon = (Polygon)new WKTReader().read(polygonWKT);
            polygon.setUserData((Object)DefaultGeographicCRS.WGS84);
            return polygon;
        }
        catch (ParseException e) {
            throw new APIException("InvalidParameterValue", "Invalid WKT specification for the polygon parameter", HttpStatus.BAD_REQUEST, (Throwable)e);
        }
    }

    private Point getPoint(String pointSpec) throws ParseException {
        String spec = pointSpec.toUpperCase();
        if (spec.startsWith("POINT")) {
            return (Point)new WKTReader().read(spec);
        }
        String[] split = spec.split("\\s*,\\s*");
        if (split.length != 2) {
            throw new APIException("InvalidParameterValue", "Invalid point specification, should be a longitude and a latitude separated by a comma", HttpStatus.BAD_REQUEST);
        }
        double x = Double.parseDouble(split[0]);
        double y = Double.parseDouble(split[1]);
        return new GeometryFactory().createPoint(new Coordinate(x, y));
    }
}

