/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.dggs;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ogcapi.v1.dggs.CollectionDocument;
import org.geoserver.ogcapi.v1.features.FeaturesResponse;
import org.geoserver.ogcapi.v1.features.RFCGeoJSONFeaturesResponse;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.Operation;
import org.geoserver.wfs.json.GeoJSONBuilder;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geoserver.wfs.request.GetFeatureRequest;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;

@Component
public class DGGSGeoJSONResponse
extends RFCGeoJSONFeaturesResponse {
    public DGGSGeoJSONResponse(GeoServer gs) {
        super(gs);
    }

    protected void writeLinks(FeatureCollectionResponse response, Operation operation, GeoJSONBuilder jw, String featureId) {
        APIRequestInfo requestInfo = APIRequestInfo.get();
        if (null == requestInfo) {
            return;
        }
        GetFeatureRequest request = GetFeatureRequest.adapt((Object)operation.getParameters()[0]);
        String baseUrl = request.getBaseUrl();
        jw.key("links");
        jw.array();
        if (response != null) {
            if (response.getPrevious() != null) {
                this.writeLink(jw, "Previous page", "application/geo+json", "prev", response.getPrevious());
            }
            if (response.getNext() != null) {
                this.writeLink(jw, "Next page", "application/geo+json", "next", response.getNext());
            }
        }
        Collection formats = requestInfo.getProducibleMediaTypes(FeaturesResponse.class, true);
        for (MediaType format : formats) {
            Map kvp = APIRequestInfo.get().getSimpleQueryMap();
            kvp.put("f", format.toString());
            String href = ResponseUtils.buildURL((String)baseUrl, (String)APIRequestInfo.get().getRequestPath(), (Map)kvp, (URLMangler.URLType)URLMangler.URLType.SERVICE);
            String linkType = "alternate";
            Object linkTitle = "This document as " + format;
            if (format.toString().equals("application/geo+json")) {
                linkType = "self";
                linkTitle = "This document";
            }
            this.writeLink(jw, (String)linkTitle, format.toString(), linkType, href);
        }
        FeatureTypeInfo featureType = this.getFeatureType(request);
        if (featureType != null) {
            String basePath = "ogc/dggs/collections/" + ResponseUtils.urlEncode((String)featureType.prefixedName(), (char[])new char[0]);
            for (MediaType format : requestInfo.getProducibleMediaTypes(CollectionDocument.class, true)) {
                String href = ResponseUtils.buildURL((String)baseUrl, (String)basePath, Collections.singletonMap("f", format.toString()), (URLMangler.URLType)URLMangler.URLType.SERVICE);
                String linkType = "collection";
                String linkTitle = "The collection description as " + format;
                this.writeLink(jw, linkTitle, format.toString(), linkType, href);
            }
        }
        jw.endArray();
    }

    public boolean canHandle(Operation operation) {
        return operation.getService() != null && "DGGS".equals(operation.getService().getId());
    }
}

