/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.dggs;

import freemarker.ext.beans.BeanModel;
import freemarker.template.SimpleDate;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ogcapi.FreemarkerTemplateSupport;
import org.geoserver.ogcapi.v1.features.GetFeatureHTMLMessageConverter;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.util.ISO8601Formatter;
import org.springframework.core.Ordered;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;

@Component
public class DGGSFeatureHTMLMessageConverter
extends GetFeatureHTMLMessageConverter
implements Ordered {
    ISO8601Formatter dateFormatter = new ISO8601Formatter();

    public DGGSFeatureHTMLMessageConverter(FreemarkerTemplateSupport templateSupport, GeoServer geoServer) {
        super(templateSupport, geoServer);
    }

    protected boolean canWrite(MediaType mediaType) {
        return Optional.of(APIRequestInfo.get()).filter(r -> r.getRequestPath().startsWith("/ogc/dggs")).isPresent() && super.canWrite(mediaType);
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    protected Template getContentTemplate(FeatureTypeInfo typeInfo) throws IOException {
        return this.templateSupport.getTemplate((ResourceInfo)typeInfo, "zones-content.ftl", DGGSFeatureHTMLMessageConverter.class);
    }

    protected Template getEmptyTemplate(FeatureTypeInfo typeInfo) throws IOException {
        return this.templateSupport.getTemplate((ResourceInfo)typeInfo, "getfeature-empty.ftl", GetFeatureHTMLMessageConverter.class);
    }

    protected Template getComplexContentTemplate(FeatureTypeInfo typeInfo) throws IOException {
        return this.templateSupport.getTemplate((ResourceInfo)typeInfo, "getfeature-complex-content.ftl", GetFeatureHTMLMessageConverter.class);
    }

    protected Template getFooterTemplate(FeatureTypeInfo referenceFeatureType) throws IOException {
        return this.templateSupport.getTemplate((ResourceInfo)referenceFeatureType, "getfeature-footer.ftl", GetFeatureHTMLMessageConverter.class);
    }

    protected Template getHeaderTemplate(FeatureTypeInfo referenceFeatureType) throws IOException {
        return this.templateSupport.getTemplate((ResourceInfo)referenceFeatureType, "getfeature-header.ftl", GetFeatureHTMLMessageConverter.class);
    }

    protected void addLinkFunctions(String baseURL, Map<String, Object> model) {
        super.addLinkFunctions(baseURL, model);
        model.put("zoneLink", this::getZoneLink);
    }

    private Object getZoneLink(List arguments) throws TemplateModelException {
        FeatureTypeInfo ft = (FeatureTypeInfo)((BeanModel)arguments.get(0)).getWrappedObject();
        DimensionInfo time = (DimensionInfo)ft.getMetadata().get("time", DimensionInfo.class);
        SimpleHash feature = (SimpleHash)arguments.get(1);
        APIRequestInfo requestInfo = APIRequestInfo.get();
        HashMap<String, Object> kvp = new HashMap<String, Object>();
        kvp.put("f", "html");
        Object zoneId = this.getAttribute(feature, "zoneId");
        if (zoneId == null) {
            return null;
        }
        kvp.put("zone_id", (String)zoneId);
        if (time != null) {
            if (time.getEndAttribute() == null) {
                Date date = this.getDateAttribute(feature, time.getAttribute());
                kvp.put("datetime", this.dateFormatter.format(date));
            } else {
                Date start = this.getDateAttribute(feature, time.getAttribute());
                Date end = this.getDateAttribute(feature, time.getEndAttribute());
                kvp.put("datetime", this.dateFormatter.format(start) + "/" + this.dateFormatter.format(end));
            }
        }
        return ResponseUtils.buildURL((String)requestInfo.getBaseURL(), (String)ResponseUtils.appendPath((String[])new String[]{requestInfo.getServiceLandingPage(), "/collections/" + feature.get("typeName") + "/zone/"}), kvp, (URLMangler.URLType)URLMangler.URLType.SERVICE);
    }

    private Date getDateAttribute(SimpleHash feature, String attribute) throws TemplateModelException {
        return ((SimpleDate)((SimpleHash)feature.get(attribute)).get("rawValue")).getAsDate();
    }

    private Object getAttribute(SimpleHash feature, String attribute) throws TemplateModelException {
        SimpleHash hash = (SimpleHash)feature.get(attribute);
        if (hash == null) {
            return null;
        }
        return hash.get("rawValue").toString();
    }
}

