/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.dggs;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.geoserver.catalog.Catalog;
import org.geoserver.config.ServiceInfo;
import org.geoserver.ogcapi.ConformanceDocument;
import org.geoserver.ogcapi.OpenAPIBuilder;
import org.geoserver.ogcapi.v1.dggs.CollectionsDocument;
import org.geoserver.ogcapi.v1.dggs.DGGSInfo;
import org.geoserver.ogcapi.v1.dggs.DGGSService;
import org.geoserver.ogcapi.v1.features.FeaturesResponse;

public class DGGSAPIBuilder
extends OpenAPIBuilder<DGGSInfo> {
    public DGGSAPIBuilder() {
        super(DGGSAPIBuilder.class, "openapi.yaml", "DGGS 1.0 server", DGGSService.class);
    }

    public OpenAPI build(DGGSInfo service) throws IOException {
        OpenAPI api = super.build((ServiceInfo)service);
        this.declareGetResponseFormats(api, "/", OpenAPI.class);
        this.declareGetResponseFormats(api, "/conformance", ConformanceDocument.class);
        this.declareGetResponseFormats(api, "/collections", org.geoserver.ogcapi.v1.features.CollectionsDocument.class);
        this.declareGetResponseFormats(api, "/collections/{collectionId}", CollectionsDocument.class);
        this.declareGetResponseFormats(api, "/collections/{collectionId}/zones", FeaturesResponse.class);
        this.declareGetResponseFormats(api, "/collections/{collectionId}/neighbors", FeaturesResponse.class);
        this.declareGetResponseFormats(api, "/collections/{collectionId}/parents", FeaturesResponse.class);
        this.declareGetResponseFormats(api, "/collections/{collectionId}/children", FeaturesResponse.class);
        this.declareGetResponseFormats(api, "/collections/{collectionId}/point", FeaturesResponse.class);
        this.declareGetResponseFormats(api, "/collections/{collectionId}/polygon", FeaturesResponse.class);
        Map parameters = api.getComponents().getParameters();
        Parameter collectionId = (Parameter)parameters.get("collectionId");
        Catalog catalog = service.getGeoServer().getCatalog();
        List validCollectionIds = catalog.getFeatureTypes().stream().filter(ft -> DGGSService.isDGGSType(ft)).map(ft -> ft.prefixedName()).collect(Collectors.toList());
        collectionId.getSchema().setEnum(validCollectionIds);
        return api;
    }
}

