/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.dggs;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.ogcapi.AbstractDocument;
import org.geoserver.ogcapi.LinksBuilder;
import org.geoserver.ogcapi.v1.dggs.CollectionDocument;
import org.geoserver.ogcapi.v1.dggs.DAPAVariable;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;

public class DAPAVariables
extends AbstractDocument {
    String collectionId;
    List<DAPAVariable> variables;

    public DAPAVariables(String collectionId, FeatureTypeInfo info) throws IOException {
        Set<String> excludedAttributes = this.getExcludedAttributes(info);
        SimpleFeatureType schema = (SimpleFeatureType)info.getFeatureType();
        this.collectionId = collectionId;
        this.variables = schema.getAttributeDescriptors().stream().filter(ad -> !(ad instanceof GeometryDescriptor) && !excludedAttributes.contains(ad.getLocalName())).map(ad -> new DAPAVariable((AttributeDescriptor)ad)).collect(Collectors.toList());
        this.addSelfLinks("ogc/dggs/v1/collections/" + collectionId + "/dapa/variables");
        new LinksBuilder(CollectionDocument.class, "ogc/dggs/collections/").segment(collectionId, true).title("foobar").rel("collection").add((AbstractDocument)this);
    }

    public Set<String> getExcludedAttributes(FeatureTypeInfo info) {
        HashSet<String> excludedAttributes = new HashSet<String>();
        excludedAttributes.add("zoneId");
        excludedAttributes.add("resolution");
        DimensionInfo time = (DimensionInfo)info.getMetadata().get("time", DimensionInfo.class);
        if (time != null) {
            excludedAttributes.add(time.getAttribute());
            if (time.getEndAttribute() != null) {
                excludedAttributes.add(time.getEndAttribute());
            }
        }
        return excludedAttributes;
    }

    public List<DAPAVariable> getVariables() {
        return this.variables;
    }

    public void setVariables(List<DAPAVariable> variables) {
        this.variables = variables;
    }

    public String getCollectionId() {
        return this.collectionId;
    }

    public void setCollectionId(String collectionId) {
        this.collectionId = collectionId;
    }
}

