/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.dggs;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.Iterator;
import java.util.List;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.config.GeoServer;
import org.geoserver.ogcapi.AbstractDocument;
import org.geoserver.ogcapi.Link;
import org.geoserver.ogcapi.v1.dggs.CollectionDocument;
import org.geoserver.ogcapi.v1.dggs.DGGSService;
import org.geoserver.platform.ServiceException;
import org.geotools.api.filter.Filter;

@JsonPropertyOrder(value={"links", "collections"})
public class CollectionsDocument
extends AbstractDocument {
    private final GeoServer geoServer;

    public CollectionsDocument(GeoServer geoServer) {
        this.geoServer = geoServer;
        String path = "ogc/dggs/collections/";
        this.addSelfLinks(path);
    }

    @JacksonXmlProperty(localName="Links")
    public List<Link> getLinks() {
        return this.links;
    }

    @JacksonXmlProperty(localName="Collection")
    public Iterator<CollectionDocument> getCollections() {
        final CloseableIterator featureTypes = this.geoServer.getCatalog().list(FeatureTypeInfo.class, (Filter)Filter.INCLUDE);
        return new Iterator<CollectionDocument>(){
            CollectionDocument next;

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                FeatureTypeInfo featureType = null;
                while (featureTypes.hasNext() && !DGGSService.isDGGSType(featureType = (FeatureTypeInfo)featureTypes.next())) {
                }
                if (featureType == null || !DGGSService.isDGGSType(featureType)) {
                    featureTypes.close();
                    return false;
                }
                try {
                    CollectionDocument collection;
                    this.next = collection = new CollectionDocument(CollectionsDocument.this.geoServer, featureType);
                    return true;
                }
                catch (Exception e) {
                    featureTypes.close();
                    throw new ServiceException("Failed to iterate over the feature types in the catalog", (Throwable)e);
                }
            }

            @Override
            public CollectionDocument next() {
                CollectionDocument result = this.next;
                this.next = null;
                return result;
            }
        };
    }
}

