/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.dggs;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.geoserver.ogcapi.v1.dggs.DGGSTestSupport;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class DAPATest
extends DGGSTestSupport {
    @Test
    public void testGetVariablesJSON() throws Exception {
        DocumentContext doc = this.getAsJSONPath("ogc/dggs/v1/collections/H3/dapa/variables", 200);
        Assert.assertEquals((Object)"Field of type String", (Object)this.readSingle(doc, "variables[?(@.id == 'shape')].description"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/dggs/v1/collections/H3/dapa/variables?f=application%2Fjson", (Object)this.readSingle(doc, "links[?(@.rel=='self')].href"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/dggs/v1/collections/H3?f=application%2Fjson", (Object)this.readSingle(doc, "links[?(@.rel=='collection' && @.type == 'application/json')].href"));
    }

    @Test
    public void testH3GetMaxSpaceTime() throws Exception {
        DocumentContext doc = this.getAsJSONPath("ogc/dggs/v1/collections/H3/dapa/area:aggregate-space-time?bbox=-10,-10,10,10&datetime=2000/2020&functions=min,max&variables=shape", 200);
        JSONArray coordinates = (JSONArray)doc.read("features[0].geometry.coordinates", JSONArray.class, new Predicate[0]);
        Assert.assertEquals((Object)"[[[-10,-10],[10,-10],[10,10],[-10,10],[-10,-10]]]", (Object)coordinates.toJSONString());
        JSONObject properties = (JSONObject)doc.read("features[0].properties", JSONObject.class, new Predicate[0]);
        Assert.assertEquals((Object)"2000/2020", (Object)properties.getAsString("phenomenonTime"));
        Assert.assertEquals((Object)"hexagon", (Object)properties.getAsString("shape_min"));
        Assert.assertEquals((Object)"pentagon", (Object)properties.getAsString("shape_max"));
    }
}

