/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.dggs;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import org.geoserver.ogcapi.v1.dggs.DGGSTestSupport;
import org.jsoup.nodes.Document;
import org.junit.Assert;
import org.junit.Test;

public class ConformanceTest
extends DGGSTestSupport {
    @Test
    public void testConformance() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/dggs/v1/conformance", 200);
        this.checkConformance(json);
    }

    private void checkConformance(DocumentContext json) {
        Assert.assertEquals((long)2L, (long)((Integer)json.read("$.length()", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)json.read("$.conformsTo.length()", Integer.class, new Predicate[0])).intValue());
        Assert.assertEquals((Object)"http://www.opengis.net/spec/ogcapi-dggs-1/1.0/conf/core", (Object)json.read("$.conformsTo[0]", String.class, new Predicate[0]));
    }

    @Test
    public void testConformanceJson() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/dggs/v1/conformance?f=json", 200);
        this.checkConformance(json);
    }

    @Test
    public void testCollectionsYaml() throws Exception {
        String yaml = this.getAsString("ogc/dggs/v1/conformance?f=application/yaml");
        this.checkConformance((DocumentContext)this.convertYamlToJsonPath(yaml));
    }

    @Test
    public void testConformanceHTML() throws Exception {
        Document document = this.getAsJSoup("ogc/dggs/v1/conformance?f=text/html");
        Assert.assertEquals((Object)"GeoServer DGGS Conformance", (Object)document.select("#title").text());
        Assert.assertEquals((Object)"http://www.opengis.net/spec/ogcapi-dggs-1/1.0/conf/core", (Object)document.select("#content li:eq(0)").text());
    }
}

