/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.coverages;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.util.ReaderDimensionsAccessor;
import org.geoserver.util.ISO8601Formatter;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.util.DateRange;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.wcs.WcsException;

class TimeDimensionHelper {
    static final Logger LOGGER = Logging.getLogger(TimeDimensionHelper.class);
    static final BigDecimal[] DURATIONS = new BigDecimal[]{new BigDecimal(31536000000L), new BigDecimal(86400000L), new BigDecimal(3600000L), new BigDecimal(60000), new BigDecimal(1000L)};
    private static final String SECONDS = "s";
    private static final String DAY = "d";
    static final String[] DURATION_UNITS = new String[]{"y", "d", "h", "min", "s"};
    DimensionInfo timeDimension;
    ReaderDimensionsAccessor accessor;
    ISO8601Formatter timeStampFormatter = new ISO8601Formatter();
    SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
    String resolutionUnit;
    long resolutionValue;

    public TimeDimensionHelper(DimensionInfo timeDimension, GridCoverage2DReader reader) throws IOException {
        this.timeDimension = timeDimension;
        this.accessor = new ReaderDimensionsAccessor(reader);
        if (timeDimension.getResolution() != null) {
            this.setupResolution(timeDimension.getResolution());
        } else {
            this.resolutionValue = 1L;
            this.resolutionUnit = SECONDS;
        }
    }

    private void setupResolution(BigDecimal resolution) {
        for (int i = 0; i < DURATIONS.length; ++i) {
            BigDecimal duration = DURATIONS[i];
            if (resolution.remainder(duration).longValue() != 0L) continue;
            this.resolutionValue = resolution.divide(duration).longValue();
            this.resolutionUnit = DURATION_UNITS[i];
            return;
        }
        throw new WcsException("Dimension's resolution requires milliseconds for full representation, but this cannot be represented in the domain set output");
    }

    public DimensionInfo getTimeDimension() {
        return this.timeDimension;
    }

    public TreeSet<Object> getTimeDomain() throws IOException {
        return this.accessor.getTimeDomain();
    }

    public List<String> getFormattedDomain() throws IOException {
        return this.accessor.getTimeDomain().stream().map(t -> this.format(t)).collect(Collectors.toList());
    }

    public String getFormattedBegin() throws IOException {
        Date minTime = this.getBegin();
        return this.format(minTime);
    }

    public Date getBegin() throws IOException {
        return this.accessor.getMinTime();
    }

    public String getFormattedEnd() throws IOException {
        Date maxTime = this.getEnd();
        return this.format(maxTime);
    }

    public Date getEnd() throws IOException {
        return this.accessor.getMaxTime();
    }

    private String format(Object time) {
        if (time instanceof Date) {
            return this.format((Date)time);
        }
        if (time instanceof DateRange) {
            DateRange range = (DateRange)time;
            return this.timeStampFormatter.format(range.getMinValue()) + "/" + this.timeStampFormatter.format(range.getMaxValue());
        }
        return null;
    }

    public String format(Date time) {
        if (time instanceof java.sql.Date) {
            return this.dateFormatter.format(time);
        }
        if (time != null) {
            return this.timeStampFormatter.format(time);
        }
        return null;
    }

    public DimensionPresentation getPresentation() {
        return this.timeDimension.getPresentation();
    }

    public String getResolutionUnit() {
        return this.resolutionUnit;
    }

    public long getResolutionValue() {
        return this.resolutionValue;
    }

    public BigDecimal getResolutionMillis() {
        return this.timeDimension.getResolution();
    }
}

