/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.coverages;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import java.util.List;
import java.util.Map;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.ogcapi.APIDispatcher;
import org.geoserver.ogcapi.v1.coverages.CoveragesResponse;
import org.geoserver.ogcapi.v1.coverages.CoveragesTestSupport;
import org.geoserver.platform.GeoServerExtensions;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jsoup.nodes.Document;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.http.MediaType;

public class CollectionTest
extends CoveragesTestSupport {
    private static final double EPS = 1.0E-6;

    @Test
    public void testCollectionJson() throws Exception {
        DocumentContext json = this.getAsJSONPath("ogc/coverages/v1/collections/rs:DEM", 200);
        this.checkDEMCoverage(json, "rs:DEM");
    }

    private void checkDEMCoverage(DocumentContext json, String expectedId) {
        Assert.assertEquals((Object)expectedId, (Object)json.read("$.id", String.class, new Predicate[0]));
        Assert.assertEquals((Object)"Down under digital elevation model", (Object)json.read("$.title", String.class, new Predicate[0]));
        Assert.assertEquals((double)145.0, (double)((Double)json.read("$.extent.spatial.bbox[0][0]", Double.class, new Predicate[0])), (double)1.0E-6);
        Assert.assertEquals((double)-43.0, (double)((Double)json.read("$.extent.spatial.bbox[0][1]", Double.class, new Predicate[0])), (double)1.0E-6);
        Assert.assertEquals((double)146.0, (double)((Double)json.read("$.extent.spatial.bbox[0][2]", Double.class, new Predicate[0])), (double)1.0E-6);
        Assert.assertEquals((double)-41.0, (double)((Double)json.read("$.extent.spatial.bbox[0][3]", Double.class, new Predicate[0])), (double)1.0E-6);
        Assert.assertEquals((Object)"http://www.opengis.net/def/crs/OGC/1.3/CRS84", (Object)json.read("$.extent.spatial.crs", String.class, new Predicate[0]));
        List<MediaType> formats = this.getCoverageFormats();
        MatcherAssert.assertThat((Object)formats.size(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)((Integer)json.read("links.length()", Integer.class, new Predicate[0]))));
        for (MediaType format : formats) {
            List items = (List)json.read("links[?(@.type=='" + format + "')]", List.class, new Predicate[0]);
            Map item = (Map)items.get(0);
            Assert.assertEquals((Object)"http://www.opengis.net/def/rel/ogc/1.0/coverage", item.get("rel"));
        }
        this.readSingle(json, "links[?(@.type=='image/geotiff')]");
        List crs = (List)json.read("crs", new Predicate[0]);
        MatcherAssert.assertThat((Object)crs, (Matcher)Matchers.hasItems((Object[])new String[]{"http://www.opengis.net/def/crs/OGC/1.3/CRS84", "http://www.opengis.net/def/crs/EPSG/0/4326", "http://www.opengis.net/def/crs/EPSG/0/3857", "http://www.opengis.net/def/crs/EPSG/0/3003"}));
    }

    private List<MediaType> getCoverageFormats() {
        return ((APIDispatcher)GeoServerExtensions.bean(APIDispatcher.class, (ApplicationContext)applicationContext)).getProducibleMediaTypes(CoveragesResponse.class, false);
    }

    @Test
    public void testCollectionVirtualWorkspace() throws Exception {
        DocumentContext json = this.getAsJSONPath("rs/ogc/coverages/v1/collections/DEM", 200);
        this.checkDEMCoverage(json, "DEM");
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/rs/ogc/coverages/v1/collections/DEM/coverage?f=image%2Fgeotiff", (Object)this.readSingle(json, "$.links[?(@.type == 'image/geotiff')].href"));
    }

    @Test
    public void testCollectionYaml() throws Exception {
        String yaml = this.getAsString("ogc/coverages/v1/collections/rs:DEM?f=application/yaml");
        this.checkDEMCoverage((DocumentContext)this.convertYamlToJsonPath(yaml), "rs:DEM");
    }

    @Test
    public void testCollectionHTML() throws Exception {
        Document document = this.getAsJSoup("ogc/coverages/v1/collections/rs:DEM?f=html");
        String tazDemName = "rs:DEM";
        String tazDemHtmlId = tazDemName.replace(":", "__");
        Assert.assertEquals((Object)"Down under digital elevation model", (Object)document.select("#" + tazDemHtmlId + "_title").text());
        Assert.assertEquals((Object)"So that you know where up and down are", (Object)document.select("#" + tazDemHtmlId + "_description").text());
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/coverages/v1/collections/rs:DEM/coverage?f=image%2Fgeotiff", (Object)document.select("#html_" + tazDemHtmlId + "_link").attr("href"));
        Assert.assertEquals((Object)"Geographic extents: 145, -43, 146, -41.", (Object)document.select("#" + tazDemHtmlId + "_spatial").text());
        Assert.assertEquals((Object)"", (Object)document.select("#" + tazDemHtmlId + "_temporal").text());
    }

    @Test
    public void testTemporalCollectionHTML() throws Exception {
        this.setupRasterDimension(TIMESERIES, "time", DimensionPresentation.LIST, null, null, null);
        Document document = this.getAsJSoup("ogc/coverages/v1/collections/sf:timeseries?f=html");
        String id = this.getLayerId(TIMESERIES).replace(":", "__");
        Assert.assertEquals((Object)"Geographic extents: 0.237, 40.562, 14.593, 44.558.", (Object)document.select("#" + id + "_spatial").text());
        Assert.assertEquals((Object)"Temporal extent: 2014-01-01T00:00:00Z/2019-01-01T00:00:00Z", (Object)document.select("#" + id + "_temporal").text());
    }

    @Test
    public void testCollectionHTMLRemovedInlineJS() throws Exception {
        String html = this.getAsString("ogc/coverages/v1/collections/rs:DEM?f=html");
        MatcherAssert.assertThat((Object)html, (Matcher)Matchers.containsString((String)"<script src=\"http://localhost:8080/geoserver/webresources/ogcapi/common.js\"></script>"));
        MatcherAssert.assertThat((Object)html, (Matcher)Matchers.containsString((String)"form-select-open-basic"));
        MatcherAssert.assertThat((Object)html, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"onchange")));
    }
}

