/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.coverages;

import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.geoserver.catalog.Catalog;
import org.geoserver.config.ServiceInfo;
import org.geoserver.ogcapi.ConformanceDocument;
import org.geoserver.ogcapi.OpenAPIBuilder;
import org.geoserver.ogcapi.v1.coverages.CollectionDocument;
import org.geoserver.ogcapi.v1.coverages.CollectionsDocument;
import org.geoserver.ogcapi.v1.coverages.CoveragesResponse;
import org.geoserver.ogcapi.v1.coverages.CoveragesService;
import org.geoserver.wcs.WCSInfo;

public class CoveragesAPIBuilder
extends OpenAPIBuilder<WCSInfo> {
    public CoveragesAPIBuilder() {
        super(CoveragesAPIBuilder.class, "openapi.yaml", "Coverages 1.0 server", CoveragesService.class);
    }

    public OpenAPI build(WCSInfo wcs) throws IOException {
        OpenAPI api = super.build((ServiceInfo)wcs);
        api.externalDocs(new ExternalDocumentation().description("Coverages specification").url("https://github.com/opengeospatial/ogcapi-coverages"));
        this.declareGetResponseFormats(api, "/", OpenAPI.class);
        this.declareGetResponseFormats(api, "/conformance", ConformanceDocument.class);
        this.declareGetResponseFormats(api, "/collections", CollectionsDocument.class);
        this.declareGetResponseFormats(api, "/collections/{collectionId}", CollectionDocument.class);
        this.declareGetResponseFormats(api, "/collections/{collectionId}/coverage", CoveragesResponse.class);
        Map parameters = api.getComponents().getParameters();
        Parameter collectionId = (Parameter)parameters.get("collectionId");
        Catalog catalog = wcs.getGeoServer().getCatalog();
        List validCollectionIds = catalog.getCoverages().stream().map(ci -> ci.prefixedName()).collect(Collectors.toList());
        collectionId.getSchema().setEnum(validCollectionIds);
        return api;
    }
}

