/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.coverages;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ResourceErrorHandling;
import org.geoserver.ogcapi.AbstractDocument;
import org.geoserver.ogcapi.Link;
import org.geoserver.ogcapi.v1.coverages.CollectionDocument;
import org.geoserver.ogcapi.v1.coverages.CoveragesService;
import org.geoserver.platform.ServiceException;
import org.geotools.api.filter.Filter;
import org.geotools.util.logging.Logging;

@JsonPropertyOrder(value={"links", "collections"})
public class CollectionsDocument
extends AbstractDocument {
    static final Logger LOGGER = Logging.getLogger(CollectionsDocument.class);
    private final GeoServer geoServer;
    private final List<String> crs;
    private final boolean skipInvalid;

    public CollectionsDocument(GeoServer geoServer, List<String> crsList) {
        this.geoServer = geoServer;
        this.crs = crsList;
        String path = "ogc/coverages/v1/collections/";
        this.addSelfLinks(path);
        this.skipInvalid = geoServer.getGlobal().getResourceErrorHandling() == ResourceErrorHandling.SKIP_MISCONFIGURED_LAYERS;
    }

    @JacksonXmlProperty(localName="Links")
    public List<Link> getLinks() {
        return this.links;
    }

    @JacksonXmlProperty(localName="Collection")
    public Iterator<CollectionDocument> getCollections() {
        final CloseableIterator coverages = this.geoServer.getCatalog().list(CoverageInfo.class, (Filter)Filter.INCLUDE);
        return new Iterator<CollectionDocument>(){
            CollectionDocument next;

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                while (coverages.hasNext()) {
                    CoverageInfo coverage = (CoverageInfo)coverages.next();
                    try {
                        CollectionDocument collection;
                        List<String> crs = CoveragesService.getCoverageCRS(coverage, Collections.singletonList("#/crs"));
                        this.next = collection = CollectionsDocument.this.getCollectionDocument(coverage, (CloseableIterator<CoverageInfo>)coverages);
                        return this.next != null;
                    }
                    catch (Exception e) {
                        if (CollectionsDocument.this.skipInvalid) {
                            LOGGER.log(Level.WARNING, "Skipping coverage type " + coverage.prefixedName());
                            continue;
                        }
                        LOGGER.log(Level.WARNING, "Failed to build collection for " + coverage.prefixedName(), e);
                        coverages.close();
                        throw new ServiceException("Failed to iterate over the coverage types in the catalog", (Throwable)e);
                    }
                }
                coverages.close();
                return false;
            }

            @Override
            public CollectionDocument next() {
                CollectionDocument result = this.next;
                this.next = null;
                return result;
            }
        };
    }

    private CollectionDocument getCollectionDocument(CoverageInfo coverage, CloseableIterator<CoverageInfo> coverages) throws IOException {
        List<String> crs = CoveragesService.getCoverageCRS(coverage, Collections.singletonList("#/crs"));
        CollectionDocument collection = new CollectionDocument(this.geoServer, coverage, crs);
        return collection;
    }

    public List<String> getCrs() {
        return this.crs;
    }
}

