/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.coverages;

import javax.servlet.http.HttpServletResponse;
import org.geoserver.config.GeoServer;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ogcapi.DefaultAPIExceptionHandler;
import org.geoserver.wcs2_0.exception.WCS20Exception;
import org.springframework.stereotype.Component;

@Component
public class WCS20ExceptionHandler
extends DefaultAPIExceptionHandler {
    public WCS20ExceptionHandler(GeoServer geoServer) {
        super(geoServer);
    }

    public boolean canHandle(Throwable t, APIRequestInfo request) {
        return t instanceof WCS20Exception;
    }

    public void handle(Throwable t, HttpServletResponse response) {
        WCS20Exception wc = (WCS20Exception)t;
        if (WCS20Exception.WCS20ExceptionCode.NoSuchCoverage.getExceptionCode().equals(wc.getCode())) {
            response.setStatus(404);
        } else if (wc.getHttpCode() == 404) {
            response.setStatus(400);
        } else {
            response.setStatus(wc.getHttpCode().intValue());
        }
        response.setContentType("application/json");
        this.writeResponse(response, t, wc.getCode(), this.getDescription(t));
    }

    public int getPriority() {
        return 0;
    }
}

