/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi.v1.coverages;

import java.util.Arrays;
import javax.xml.namespace.QName;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ogcapi.OGCApiTestSupport;

public class CoveragesTestSupport
extends OGCApiTestSupport {
    protected static final String TAZDEM_TITLE = "Down under digital elevation model";
    protected static final String TAZDEM_DESCRIPTION = "So that you know where up and down are";
    protected static final QName TIMESERIES = new QName(MockData.SF_URI, "timeseries", MockData.SF_PREFIX);

    protected void setUpTestData(SystemTestData testData) throws Exception {
        super.setUpTestData(testData);
        testData.setUpDefaultRasterLayers();
    }

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        Catalog catalog = this.getCatalog();
        WorkspaceInfo wcs = catalog.getWorkspaceByName("wcs");
        wcs.setName("rs");
        catalog.save(wcs);
        CoverageInfo tazDem = this.getCatalog().getCoverageByName("rs:DEM");
        tazDem.setTitle(TAZDEM_TITLE);
        tazDem.setAbstract(TAZDEM_DESCRIPTION);
        tazDem.getResponseSRS().addAll(Arrays.asList("3857", "3003"));
        this.getCatalog().save((ResourceInfo)tazDem);
        testData.addRasterLayer(TIMESERIES, "timeseries.zip", null, this.getCatalog());
    }
}

