/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import java.util.Date;
import java.util.List;
import javax.xml.namespace.QName;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ogcapi.TimeExtentCalculator;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geotools.util.Converters;
import org.geotools.util.DateRange;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TimeExtentCalculatorTest
extends GeoServerSystemTestSupport {
    protected QName V_TIME_ELEVATION = new QName(MockData.SF_URI, "TimeElevation", MockData.SF_PREFIX);
    protected QName V_TIME_ELEVATION_EMPTY = new QName(MockData.SF_URI, "TimeElevationEmpty", MockData.SF_PREFIX);
    protected static QName TIMESERIES = new QName(MockData.SF_URI, "timeseries", MockData.SF_PREFIX);

    protected void onSetUp(SystemTestData testData) throws Exception {
        Catalog catalog = this.getCatalog();
        testData.addVectorLayer(this.V_TIME_ELEVATION, null, "TimeElevation.properties", TimeExtentCalculatorTest.class, catalog);
        testData.addVectorLayer(this.V_TIME_ELEVATION_EMPTY, null, "TimeElevationEmpty.properties", TimeExtentCalculatorTest.class, catalog);
    }

    @Before
    public void cleanupDimensions() throws Exception {
        ((SystemTestData)this.getTestData()).addRasterLayer(TIMESERIES, "timeseries.zip", null, null, SystemTestData.class, this.getCatalog());
        Catalog catalog = this.getCatalog();
        List resources = catalog.getResources(ResourceInfo.class);
        for (ResourceInfo resource : resources) {
            if (!resource.getMetadata().containsKey((Object)"time")) continue;
            resource.getMetadata().remove((Object)"time");
            catalog.save(resource);
        }
    }

    @Test
    public void testVectorTimeMissing() throws Exception {
        FeatureTypeInfo ft = this.getCatalog().getFeatureTypeByName(this.getLayerId(this.V_TIME_ELEVATION));
        Assert.assertNull((Object)TimeExtentCalculator.getTimeExtent((ResourceInfo)ft));
    }

    @Test
    public void testRasterTimeMissing() throws Exception {
        CoverageInfo ci = this.getCatalog().getCoverageByName(this.getLayerId(TIMESERIES));
        Assert.assertNull((Object)TimeExtentCalculator.getTimeExtent((ResourceInfo)ci));
    }

    @Test
    public void testVectorTimeDisabled() throws Exception {
        this.setupVectorDimension(this.getLayerId(this.V_TIME_ELEVATION), "time", "time", DimensionPresentation.LIST, null, null, null);
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo ft = catalog.getFeatureTypeByName(this.getLayerId(this.V_TIME_ELEVATION));
        DimensionInfo di = (DimensionInfo)ft.getMetadata().get("time", DimensionInfo.class);
        di.setEnabled(false);
        catalog.save((ResourceInfo)ft);
        Assert.assertNull((Object)TimeExtentCalculator.getTimeExtent((ResourceInfo)ft));
    }

    @Test
    public void testRasterTimeDisabled() throws Exception {
        this.setupRasterDimension(TIMESERIES, "time", DimensionPresentation.LIST, null, null, null);
        Catalog catalog = this.getCatalog();
        CoverageInfo ci = catalog.getCoverageByName(this.getLayerId(TIMESERIES));
        DimensionInfo di = (DimensionInfo)ci.getMetadata().get("time", DimensionInfo.class);
        di.setEnabled(false);
        catalog.save((ResourceInfo)ci);
        Assert.assertNull((Object)TimeExtentCalculator.getTimeExtent((ResourceInfo)ci));
    }

    @Test
    public void testVectorTimeEmpty() throws Exception {
        this.setupVectorDimension(this.getLayerId(this.V_TIME_ELEVATION_EMPTY), "time", "time", DimensionPresentation.LIST, null, null, null);
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo ft = catalog.getFeatureTypeByName(this.getLayerId(this.V_TIME_ELEVATION_EMPTY));
        catalog.save((ResourceInfo)ft);
        Assert.assertNull((Object)TimeExtentCalculator.getTimeExtent((ResourceInfo)ft));
    }

    @Test
    public void testVectorTime() throws Exception {
        this.setupVectorDimension(this.getLayerId(this.V_TIME_ELEVATION), "time", "time", DimensionPresentation.LIST, null, null, null);
        FeatureTypeInfo ft = this.getCatalog().getFeatureTypeByName(this.getLayerId(this.V_TIME_ELEVATION));
        DateRange extent = TimeExtentCalculator.getTimeExtent((ResourceInfo)ft);
        Assert.assertEquals((Object)Converters.convert((Object)"2011-05-01Z", Date.class), (Object)extent.getMinValue());
        Assert.assertEquals((Object)Converters.convert((Object)"2011-05-04Z", Date.class), (Object)extent.getMaxValue());
    }

    @Test
    public void testRasterTime() throws Exception {
        this.setupRasterDimension(TIMESERIES, "time", DimensionPresentation.LIST, null, null, null);
        CoverageInfo ci = this.getCatalog().getCoverageByName(this.getLayerId(TIMESERIES));
        DateRange extent = TimeExtentCalculator.getTimeExtent((ResourceInfo)ci);
        Assert.assertEquals((Object)Converters.convert((Object)"2014-01-01Z", Date.class), (Object)extent.getMinValue());
        Assert.assertEquals((Object)Converters.convert((Object)"2019-01-01Z", Date.class), (Object)extent.getMaxValue());
    }
}

