/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import java.io.IOException;
import java.util.Date;
import java.util.logging.Logger;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.util.ReaderDimensionsAccessor;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.MaxVisitor;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.util.DateRange;
import org.geotools.util.logging.Logging;

public class TimeExtentCalculator {
    static final Logger LOGGER = Logging.getLogger(TimeExtentCalculator.class);

    private TimeExtentCalculator() {
    }

    public static DateRange getTimeExtent(ResourceInfo ri) throws IOException {
        DimensionInfo time = (DimensionInfo)ri.getMetadata().get("time", DimensionInfo.class);
        if (time == null || !time.isEnabled()) {
            return null;
        }
        if (ri instanceof FeatureTypeInfo) {
            return TimeExtentCalculator.getTimeExtent((FeatureTypeInfo)ri, time);
        }
        if (ri instanceof CoverageInfo) {
            return TimeExtentCalculator.getTimeExtent((CoverageInfo)ri);
        }
        LOGGER.fine("Time extent calculation support not yet available for " + ri);
        return null;
    }

    private static DateRange getTimeExtent(FeatureTypeInfo ft, DimensionInfo time) throws IOException {
        FeatureSource fs = ft.getFeatureSource(null, null);
        FeatureCollection collection = fs.getFeatures();
        MinVisitor min = new MinVisitor(time.getAttribute());
        collection.accepts((FeatureVisitor)min, null);
        CalcResult minResult = min.getResult();
        if (minResult != CalcResult.NULL_RESULT) {
            Date minDate = (Date)min.getMin();
            MaxVisitor max = new MaxVisitor(time.getAttribute());
            collection.accepts((FeatureVisitor)max, null);
            Date maxDate = (Date)max.getMax();
            if (minDate != null && maxDate != null) {
                return new DateRange(minDate, maxDate);
            }
        }
        return null;
    }

    private static DateRange getTimeExtent(CoverageInfo ci) throws IOException {
        ReaderDimensionsAccessor accessor = new ReaderDimensionsAccessor((GridCoverage2DReader)ci.getGridCoverageReader(null, null));
        Date minTime = accessor.getMinTime();
        Date maxTime = accessor.getMaxTime();
        if (minTime != null && maxTime != null) {
            return new DateRange(minTime, maxTime);
        }
        return null;
    }
}

