/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ogcapi.AbstractDocument;
import org.geoserver.ogcapi.HttpHeaderLinksAppender;
import org.geoserver.ogcapi.Link;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.springframework.http.MediaType;

public class LinksBuilder {
    private final Class<?> responseType;
    private List<String> segments = new ArrayList<String>();
    private String title = "Resource as ";
    private String rel;
    private boolean includeHTML = true;
    private String classification;
    private BiConsumer<MediaType, Link> updater;
    private Function<List<MediaType>, List<MediaType>> mediaTypeCustomizer;
    private boolean appendToHead = true;

    public LinksBuilder(Class<?> responseType) {
        this.responseType = responseType;
    }

    public LinksBuilder(Class<?> responseType, String path) {
        this.responseType = responseType;
        this.segments.add(path);
    }

    public LinksBuilder segment(String segment) {
        this.segments.add(segment);
        return this;
    }

    public LinksBuilder mediaTypeCustomizer(Function<List<MediaType>, List<MediaType>> mediaTypeCustomizer) {
        this.mediaTypeCustomizer = mediaTypeCustomizer;
        return this;
    }

    public LinksBuilder segment(String segment, boolean urlEncode) {
        if (!urlEncode) {
            return this.segment(segment);
        }
        this.segments.add(ResponseUtils.urlEncode((String)segment, (char[])new char[]{':'}));
        return this;
    }

    public LinksBuilder title(String title) {
        this.title = title;
        return this;
    }

    public LinksBuilder rel(String rel) {
        this.rel = rel;
        return this;
    }

    public LinksBuilder html(boolean includeHTML) {
        this.includeHTML = includeHTML;
        return this;
    }

    public LinksBuilder classification(String classification) {
        this.classification = classification;
        return this;
    }

    public LinksBuilder updater(BiConsumer<MediaType, Link> updater) {
        this.updater = updater;
        return this;
    }

    public LinksBuilder appendToHead(boolean append) {
        this.appendToHead = append;
        return this;
    }

    public List<Link> build() {
        ArrayList<Link> result = new ArrayList<Link>();
        List<MediaType> mediaTypes = new ArrayList<MediaType>(APIRequestInfo.get().getProducibleMediaTypes(this.responseType, this.includeHTML));
        if (this.mediaTypeCustomizer != null) {
            mediaTypes = this.mediaTypeCustomizer.apply(mediaTypes);
        }
        for (MediaType mediaType : mediaTypes) {
            String format = mediaType.toString();
            Map<String, String> params = Collections.singletonMap("f", format);
            String url = ResponseUtils.buildURL((String)APIRequestInfo.get().getBaseURL(), (String)this.getPath(), params, (URLMangler.URLType)URLMangler.URLType.SERVICE);
            String linkTitle = this.title + format;
            Link link = new Link(url, this.rel, format, linkTitle);
            link.setClassification(this.getClassification());
            if (this.updater != null) {
                this.updater.accept(mediaType, link);
            }
            result.add(link);
        }
        if (this.appendToHead) {
            result.forEach(l -> HttpHeaderLinksAppender.addLink(l));
        }
        return result;
    }

    public void add(AbstractDocument document) {
        document.getLinks().addAll(this.build());
    }

    private String getClassification() {
        if (this.classification != null) {
            return this.classification;
        }
        int idx = this.rel.lastIndexOf(47);
        if (idx == -1) {
            return this.rel;
        }
        return this.rel.substring(idx + 1);
    }

    private String getPath() {
        return ResponseUtils.appendPath((String[])this.segments.toArray(new String[this.segments.size()]));
    }
}

