/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.geoserver.catalog.Catalog;
import org.geoserver.filters.GeoServerFilter;
import org.geoserver.ogcapi.APIDispatcher;
import org.geoserver.ogcapi.APIService;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class LandingPageSlashFilter
implements GeoServerFilter,
ApplicationContextAware {
    private final Catalog catalog;
    private List<APIService> services;

    public LandingPageSlashFilter(Catalog catalog) {
        this.catalog = catalog;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletRequest instanceof HttpServletRequest && this.isLandingPageWithSlash((HttpServletRequest)servletRequest)) {
            filterChain.doFilter((ServletRequest)new SlashWrapper(servletRequest), servletResponse);
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    private boolean isLandingPageWithSlash(HttpServletRequest servletRequest) {
        String requestURI = servletRequest.getRequestURI();
        int contextPathLength = servletRequest.getContextPath().length();
        if (requestURI.length() <= contextPathLength) {
            return false;
        }
        String path = requestURI.substring(contextPathLength + 1);
        if (!path.endsWith("/")) {
            return false;
        }
        return this.services.stream().anyMatch(s -> this.matchesServiceLandingPage(path, (APIService)s));
    }

    private boolean matchesServiceLandingPage(String path, APIService s) {
        String landingPageSlash = s.landingPage() + "/";
        if (path.equals(landingPageSlash)) {
            return true;
        }
        String[] components = path.split("/");
        if (components.length <= 3) {
            return false;
        }
        String token1 = components[0];
        if (this.catalog.getWorkspaceByName(token1) == null && this.catalog.getLayerGroupByName(token1) == null) {
            return false;
        }
        if (landingPageSlash.equals(LandingPageSlashFilter.toLandingPath(components, 1L))) {
            return true;
        }
        String token2 = components[1];
        if (this.catalog.getLayerByName(token1 + ":" + token2) == null) {
            return false;
        }
        return landingPageSlash.equals(LandingPageSlashFilter.toLandingPath(components, 2L));
    }

    private static String toLandingPath(String[] components, long skip) {
        return Arrays.stream(components).skip(skip).collect(Collectors.joining("/")) + "/";
    }

    public void destroy() {
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.services = applicationContext.getBeansWithAnnotation(APIService.class).values().stream().map(o -> APIDispatcher.getApiServiceAnnotation(o.getClass())).collect(Collectors.toList());
    }

    private class SlashWrapper
    extends HttpServletRequestWrapper {
        public SlashWrapper(ServletRequest request) {
            super((HttpServletRequest)request);
        }

        public String getPathInfo() {
            String path = super.getPathInfo();
            return this.removeTrailingSlash(path);
        }

        public String getRequestURI() {
            String uri = super.getRequestURI();
            return this.removeTrailingSlash(uri);
        }

        public StringBuffer getRequestURL() {
            StringBuffer url = super.getRequestURL();
            url.setLength(url.length() - 1);
            return url;
        }

        private String removeTrailingSlash(String uri) {
            return uri.substring(0, uri.length() - 1);
        }
    }
}

