/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.config.GeoServer;
import org.geoserver.ogcapi.AbstractAPIExceptionHandler;
import org.geoserver.platform.ExtensionPriority;
import org.springframework.stereotype.Component;

@Component
public class DefaultAPIExceptionHandler
extends AbstractAPIExceptionHandler
implements ExtensionPriority {
    public DefaultAPIExceptionHandler(GeoServer geoServer) {
        super(geoServer);
    }

    @Override
    protected void writeResponse(HttpServletResponse response, Throwable t, String type, String title) {
        LinkedHashMap<String, String> error = new LinkedHashMap<String, String>();
        error.put("type", type);
        error.put("title", title);
        String trace = this.getStackTrace(t);
        if (trace != null) {
            error.put("detail", trace);
        }
        try (ServletOutputStream os = response.getOutputStream();){
            ObjectMapper mapper = new ObjectMapper();
            mapper.writeValue((OutputStream)os, error);
            os.flush();
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, "Problem writing exception information back to calling client:", ex);
        }
    }

    @Override
    protected String getDescription(Throwable t) {
        String description = super.getDescription(t);
        String trace = this.getStackTrace(t);
        if (trace != null) {
            return description + "\nDetails:\n" + trace;
        }
        return description;
    }

    public int getPriority() {
        return 100;
    }
}

