/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.ogcapi.APIContentNegotiationManager;
import org.geoserver.ogcapi.APIDispatcher;
import org.geoserver.ogcapi.APIService;
import org.geoserver.ogcapi.DefaultContentType;
import org.geoserver.ogcapi.FreemarkerTemplateSupport;
import org.geoserver.ogcapi.HTMLResponseBody;
import org.geoserver.ogcapi.ResponseMessageConverter;
import org.geoserver.ogcapi.SimpleHTMLMessageConverter;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.DispatcherCallback;
import org.geoserver.ows.Request;
import org.geoserver.ows.Response;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.mvc.method.annotation.JsonViewResponseBodyAdvice;
import org.springframework.web.servlet.mvc.method.annotation.RequestResponseBodyMethodProcessor;

public class APIBodyMethodProcessor
extends RequestResponseBodyMethodProcessor {
    private static final MediaType MEDIA_TYPE_APPLICATION = new MediaType("application");
    private static final String VERSION_HEADER = "API-Version";
    private final ContentNegotiationManager contentNegotiationManager;
    protected final FreemarkerTemplateSupport templateSupport;
    protected final GeoServer geoServer;
    protected List<DispatcherCallback> callbacks;

    public APIBodyMethodProcessor(List<HttpMessageConverter<?>> converters, FreemarkerTemplateSupport templateSupport, GeoServer geoServer, List<DispatcherCallback> callbacks) {
        this(converters, new APIContentNegotiationManager(), templateSupport, geoServer, callbacks);
    }

    public APIBodyMethodProcessor(List<HttpMessageConverter<?>> converters, ContentNegotiationManager contentNegotiationManager, FreemarkerTemplateSupport templateSupport, GeoServer geoServer, List<DispatcherCallback> callbacks) {
        super(converters, (ContentNegotiationManager)new APIContentNegotiationManager(), Collections.singletonList(new JsonViewResponseBodyAdvice()));
        this.contentNegotiationManager = contentNegotiationManager;
        this.templateSupport = templateSupport;
        this.geoServer = geoServer;
        this.callbacks = callbacks;
        Collections.sort(this.messageConverters, AnnotationAwareOrderComparator.INSTANCE);
    }

    protected <T> void writeWithMessageConverters(@Nullable T value, MethodParameter returnType, ServletServerHttpRequest inputMessage, ServletServerHttpResponse outputMessage) throws IOException, HttpMediaTypeNotAcceptableException, HttpMessageNotWritableException {
        Object converter;
        HttpServletResponse servletResponse = outputMessage.getServletResponse();
        if (value == null) {
            servletResponse.setStatus(HttpStatus.NO_CONTENT.value());
            return;
        }
        HTMLResponseBody htmlResponseBody = (HTMLResponseBody)returnType.getMethodAnnotation(HTMLResponseBody.class);
        MediaType mediaType = this.getMediaTypeToUse(value, returnType, inputMessage, outputMessage);
        if (htmlResponseBody != null && MediaType.TEXT_HTML.isCompatibleWith(mediaType)) {
            Class baseClass = htmlResponseBody.baseClass();
            if (baseClass == Object.class) {
                baseClass = returnType.getContainingClass();
            }
            converter = new SimpleHTMLMessageConverter(value.getClass(), this.getServiceClass(returnType), baseClass, this.templateSupport, this.geoServer, htmlResponseBody.templateName());
            mediaType = MediaType.TEXT_HTML;
        } else {
            converter = this.getMessageConverter(value, returnType, inputMessage, outputMessage);
        }
        final MediaType finalMediaType = mediaType;
        Response response = new Response(value.getClass(), (HttpMessageConverter)converter, outputMessage){
            final /* synthetic */ HttpMessageConverter val$converter;
            final /* synthetic */ ServletServerHttpResponse val$outputMessage;
            {
                this.val$converter = httpMessageConverter;
                this.val$outputMessage = servletServerHttpResponse;
                super(binding);
            }

            public String getMimeType(Object value, Operation operation) throws ServiceException {
                return finalMediaType.toString();
            }

            public void write(Object value, OutputStream output, Operation operation) throws IOException, ServiceException {
                this.val$converter.write(value, finalMediaType, (HttpOutputMessage)this.val$outputMessage);
            }
        };
        Request dr = (Request)Dispatcher.REQUEST.get();
        response = this.fireResponseDispatchedCallback(dr, dr.getOperation(), value, response);
        APIService apiService = APIDispatcher.getApiServiceAnnotation(returnType.getContainingClass());
        if (apiService != null && apiService.version() != null) {
            outputMessage.getHeaders().add(VERSION_HEADER, apiService.version());
        } else {
            this.logger.debug((Object)("Could not find the APIService annotation in the controller for:" + returnType.getContainingClass()));
        }
        outputMessage.getHeaders().setContentType(MediaType.parseMediaType((String)response.getMimeType(value, dr.getOperation())));
        response.write(value, (OutputStream)servletResponse.getOutputStream(), dr.getOperation());
    }

    private Class<? extends ServiceInfo> getServiceClass(MethodParameter returnType) {
        APIService apiService = APIDispatcher.getApiServiceAnnotation(returnType.getContainingClass());
        if (apiService != null) {
            return apiService.serviceClass();
        }
        throw new RuntimeException("Could not find the APIService annotation in the controller");
    }

    private List<MediaType> getAcceptableMediaTypes(HttpServletRequest request) throws HttpMediaTypeNotAcceptableException {
        return this.contentNegotiationManager.resolveMediaTypes((NativeWebRequest)new ServletWebRequest(request));
    }

    public <T> MediaType getMediaTypeToUse(@Nullable T value, MethodParameter returnType, ServletServerHttpRequest inputMessage, ServletServerHttpResponse outputMessage) throws HttpMediaTypeNotAcceptableException {
        Object targetType;
        Class valueType;
        Object body;
        if (value instanceof CharSequence) {
            body = value.toString();
            valueType = String.class;
            targetType = String.class;
        } else {
            body = value;
            valueType = this.getReturnValueType(body, returnType);
            targetType = GenericTypeResolver.resolveType((Type)this.getGenericType(returnType), (Class)returnType.getContainingClass());
        }
        if (this.isResourceType(value, returnType)) {
            return null;
        }
        MediaType selectedMediaType = null;
        MediaType contentType = outputMessage.getHeaders().getContentType();
        if (contentType != null && contentType.isConcrete()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found 'Content-Type:" + contentType + "' in response"));
            }
            selectedMediaType = contentType;
        } else {
            HTMLResponseBody htmlResponseBody;
            HttpServletRequest request = inputMessage.getServletRequest();
            List<MediaType> acceptableTypes = this.getAcceptableMediaTypes(request);
            List<MediaType> producibleTypes = this.getProducibleMediaTypes(request, valueType, (Type)targetType, value);
            if (ContentNegotiationManager.MEDIA_TYPE_ALL_LIST.equals(acceptableTypes)) {
                MediaType defaultMediaType = Optional.ofNullable((DefaultContentType)returnType.getMethodAnnotation(DefaultContentType.class)).map(t -> MediaType.parseMediaType((String)t.value())).orElse(null);
                if (defaultMediaType != null) {
                    acceptableTypes = Collections.singletonList(defaultMediaType);
                } else if (producibleTypes.contains(MediaType.APPLICATION_JSON)) {
                    acceptableTypes = Collections.singletonList(MediaType.APPLICATION_JSON);
                }
            }
            if ((htmlResponseBody = (HTMLResponseBody)returnType.getMethodAnnotation(HTMLResponseBody.class)) != null) {
                producibleTypes.add(MediaType.TEXT_HTML);
            }
            if (body != null && producibleTypes.isEmpty()) {
                throw new HttpMessageNotWritableException("No converter found for return value of type: " + valueType);
            }
            ArrayList<MediaType> mediaTypesToUse = new ArrayList<MediaType>();
            for (MediaType requestedType : acceptableTypes) {
                for (MediaType producibleType : producibleTypes) {
                    if (!requestedType.isCompatibleWith(producibleType)) continue;
                    mediaTypesToUse.add(this.getMostSpecificMediaType(requestedType, producibleType));
                }
            }
            if (mediaTypesToUse.isEmpty()) {
                if (body != null) {
                    throw new HttpMediaTypeNotAcceptableException(producibleTypes);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("No match for " + acceptableTypes + ", supported: " + producibleTypes));
                }
                return null;
            }
            for (MediaType mediaType : mediaTypesToUse) {
                for (MediaType acceptableType : acceptableTypes) {
                    if (!mediaType.equals((Object)acceptableType)) continue;
                    selectedMediaType = mediaType;
                    break;
                }
                if (selectedMediaType == null) continue;
                break;
            }
            if (selectedMediaType == null) {
                MediaType.sortBySpecificityAndQuality(mediaTypesToUse);
                for (MediaType mediaType : mediaTypesToUse) {
                    if (mediaType.isConcrete()) {
                        selectedMediaType = mediaType;
                        break;
                    }
                    if (!mediaType.equals((Object)MediaType.ALL) && !mediaType.equals((Object)MEDIA_TYPE_APPLICATION)) continue;
                    selectedMediaType = MediaType.APPLICATION_OCTET_STREAM;
                    break;
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Using '" + selectedMediaType + "', given " + acceptableTypes + " and supported " + producibleTypes));
            }
        }
        return selectedMediaType;
    }

    protected List<MediaType> getProducibleMediaTypes(HttpServletRequest request, Class<?> valueClass) {
        return this.getProducibleMediaTypes(request, valueClass, null);
    }

    protected List<MediaType> getProducibleMediaTypes(HttpServletRequest request, Class<?> valueClass, @Nullable Type targetType, Object value) {
        Set mediaTypes = (Set)request.getAttribute(HandlerMapping.PRODUCIBLE_MEDIA_TYPES_ATTRIBUTE);
        if (!CollectionUtils.isEmpty((Collection)mediaTypes)) {
            return new ArrayList<MediaType>(mediaTypes);
        }
        ArrayList<MediaType> result = new ArrayList<MediaType>();
        for (HttpMessageConverter converter : this.messageConverters) {
            if (converter instanceof ResponseMessageConverter && converter.canWrite(valueClass, null)) {
                result.addAll(((ResponseMessageConverter)converter).getSupportedMediaTypes(valueClass, value));
                continue;
            }
            if (converter instanceof GenericHttpMessageConverter && targetType != null) {
                if (!((GenericHttpMessageConverter)converter).canWrite(targetType, valueClass, null)) continue;
                result.addAll(converter.getSupportedMediaTypes());
                continue;
            }
            if (!converter.canWrite(valueClass, null)) continue;
            result.addAll(converter.getSupportedMediaTypes());
        }
        return result.isEmpty() ? Collections.singletonList(MediaType.ALL) : result;
    }

    private MediaType getMostSpecificMediaType(MediaType acceptType, MediaType produceType) {
        MediaType produceTypeToUse = produceType.copyQualityValue(acceptType);
        return MediaType.SPECIFICITY_COMPARATOR.compare(acceptType, produceTypeToUse) <= 0 ? acceptType : produceTypeToUse;
    }

    private Type getGenericType(MethodParameter returnType) {
        if (HttpEntity.class.isAssignableFrom(returnType.getParameterType())) {
            return ResolvableType.forType((Type)returnType.getGenericParameterType()).getGeneric(new int[0]).getType();
        }
        return returnType.getGenericParameterType();
    }

    protected <T> HttpMessageConverter<T> getMessageConverter(@Nullable T value, MethodParameter returnType, ServletServerHttpRequest inputMessage, ServletServerHttpResponse outputMessage) throws IOException, HttpMediaTypeNotAcceptableException, HttpMessageNotWritableException {
        Object targetType;
        Class valueType;
        Object body;
        if (value instanceof CharSequence) {
            body = value.toString();
            valueType = String.class;
            targetType = String.class;
        } else {
            body = value;
            valueType = this.getReturnValueType(value, returnType);
            targetType = GenericTypeResolver.resolveType((Type)this.getGenericType(returnType), (Class)returnType.getContainingClass());
        }
        MediaType selectedMediaType = this.getMediaTypeToUse(value, returnType, inputMessage, outputMessage);
        if (selectedMediaType != null) {
            selectedMediaType = selectedMediaType.removeQualityValue();
            for (HttpMessageConverter converter : this.messageConverters) {
                if (converter instanceof ResponseMessageConverter && ((ResponseMessageConverter)converter).canWrite(value, selectedMediaType)) {
                    return converter;
                }
                if (converter instanceof GenericHttpMessageConverter && ((GenericHttpMessageConverter)converter).canWrite((Type)targetType, valueType, selectedMediaType)) {
                    return converter;
                }
                if (!converter.canWrite(valueType, selectedMediaType)) continue;
                return converter;
            }
        }
        if (body != null) {
            throw new HttpMediaTypeNotAcceptableException(this.getSupportedMediaTypes(Object.class));
        }
        return null;
    }

    Response fireResponseDispatchedCallback(Request req, Operation op, Object result, Response response) {
        for (DispatcherCallback cb : this.callbacks) {
            Response r = cb.responseDispatched(req, op, result, response);
            response = r != null ? r : response;
        }
        return response;
    }
}

