/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import org.geoserver.config.ServiceInfo;
import org.geoserver.ogcapi.APIService;
import org.geoserver.ogcapi.Message;
import org.geoserver.ows.HttpErrorCodeException;
import org.geoserver.platform.ServiceException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@APIService(service="Hello", version="1.0.1", landingPage="ogc/hello/v1", serviceClass=HelloServiceInfo.class)
@RequestMapping(path={"ogc/hello/v1"})
public class HelloController {
    String defaultValue = "hello";

    @GetMapping(name="landingPage")
    @ResponseBody
    public Message landingPage() {
        return new Message("Landing page");
    }

    @GetMapping(path={"hello"}, name="sayHello")
    @ResponseBody
    public Message hello(@RequestParam(name="message", required=false) String message) {
        return new Message(message != null ? message : this.defaultValue);
    }

    @PostMapping(path={"echo"})
    @ResponseBody
    public ResponseEntity echo(@RequestBody Message message) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.TEXT_PLAIN);
        return new ResponseEntity((Object)message.getMessage(), (MultiValueMap)headers, HttpStatus.CREATED);
    }

    @DeleteMapping(path={"delete"})
    @ResponseBody
    public ResponseEntity<String> delete() {
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @PutMapping(path={"default"})
    public void putDefault(@RequestBody String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @GetMapping(path={"noContent"})
    public void httpErrorCodeException() {
        throw new HttpErrorCodeException(204);
    }

    @GetMapping(path={"wrappedException"})
    public void wrappedHttpErrorCodeException() {
        try {
            throw new HttpErrorCodeException(204);
        }
        catch (Exception e) {
            throw new ServiceException("Wrapping code error", (Throwable)e);
        }
    }

    @GetMapping(path={"badRequest"})
    public void badRequestHttpErrorCodeException() {
        throw new HttpErrorCodeException(400);
    }

    @GetMapping(path={"errorWithPayload"})
    public void httpErrorCodeExceptionWithContentType() {
        throw new HttpErrorCodeException(200, "{\"hello\":\"world\"}").setContentType("application/json");
    }

    static interface HelloServiceInfo
    extends ServiceInfo {
    }
}

