/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.ogcapi.APIDispatcher;
import org.geoserver.ogcapi.HelloController;
import org.geoserver.ows.Request;
import org.geoserver.ows.Response;
import org.geoserver.ows.TestDispatcherCallback;
import org.geoserver.platform.Operation;
import org.geoserver.platform.Service;
import org.geoserver.test.CodeExpectingHttpServletResponse;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.servlet.handler.DispatcherServletWebRequest;

@Ignore
public class APIDispatcherTest {
    private FileSystemXmlApplicationContext applicationContext;

    @Before
    public void setup() {
        URL url = this.getClass().getResource("applicationContext.xml");
        this.applicationContext = new FileSystemXmlApplicationContext(url.toString());
    }

    @After
    public void teardown() {
        this.applicationContext.close();
    }

    @Test
    public void testDefaultFormat() throws Exception {
        APIDispatcher dispatcher = this.getDispatcher();
        MockHttpServletRequest request = this.setupHelloRequest(new String[0]);
        MockHttpServletResponse response = new MockHttpServletResponse();
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        Assert.assertEquals((Object)"{\"message\":\"hello\"}", (Object)response.getContentAsString());
    }

    @Test
    public void testQueryParameters() throws Exception {
        APIDispatcher dispatcher = this.getDispatcher();
        MockHttpServletRequest request = this.setupHelloRequest("message", "yo", "f", "json");
        MockHttpServletResponse response = new MockHttpServletResponse();
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        Assert.assertEquals((Object)"{\"message\":\"yo\"}", (Object)response.getContentAsString());
    }

    @Test
    @Ignore
    public void testXMLFormatQueryParameter() throws Exception {
        APIDispatcher dispatcher = this.getDispatcher();
        MockHttpServletRequest request = this.setupHelloRequest("f", "xml");
        MockHttpServletResponse response = new MockHttpServletResponse();
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/xml", (Object)response.getContentType());
        Assert.assertEquals((Object)"<Message><message>hello</message></Message>", (Object)response.getContentAsString());
    }

    @Test
    @Ignore
    public void testXMLFormatAcceptHeader() throws Exception {
        APIDispatcher dispatcher = this.getDispatcher();
        MockHttpServletRequest request = this.setupHelloRequest(new String[0]);
        request.addHeader("Accept", (Object)"application/xml");
        MockHttpServletResponse response = new MockHttpServletResponse();
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/xml", (Object)response.getContentType());
        Assert.assertEquals((Object)"<Message><message>hello</message></Message>", (Object)response.getContentAsString());
    }

    @Test
    public void testPostRequest() throws Exception {
        APIDispatcher dispatcher = this.getDispatcher();
        String message = "{\"message\":\"Is there anyone here?\"}";
        MockHttpServletRequest request = this.setupEchoRequest(message, "f", "json");
        request.addHeader("Content-Type", (Object)"application/json");
        MockHttpServletResponse response = new MockHttpServletResponse();
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        Assert.assertEquals((Object)"Is there anyone here?", (Object)response.getContentAsString());
    }

    @Test
    public void testDeleteRequest() throws Exception {
        APIDispatcher dispatcher = this.getDispatcher();
        MockHttpServletRequest request = this.setupDeleteRequest();
        request.addHeader("Content-Type", (Object)"application/json");
        MockHttpServletResponse response = new MockHttpServletResponse();
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assert.assertEquals((long)204L, (long)response.getStatus());
    }

    @Test
    public void testPutRequest() throws Exception {
        try (FileSystemXmlApplicationContext context = this.applicationContext;){
            APIDispatcher dispatcher = (APIDispatcher)context.getBean(APIDispatcher.class);
            HelloController controller = (HelloController)context.getBean(HelloController.class);
            String newDefault = "ciao";
            MockHttpServletRequest request = this.setupPutRequest(newDefault, new String[0]);
            request.addHeader("Content-Type", (Object)MediaType.TEXT_PLAIN);
            MockHttpServletResponse response = new MockHttpServletResponse();
            dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            Assert.assertEquals((Object)newDefault, (Object)controller.defaultValue);
        }
    }

    @Test
    public void testDispatcherCallback() throws Exception {
        APIDispatcher dispatcher = this.getDispatcher();
        TestDispatcherCallback callback = new TestDispatcherCallback();
        MockHttpServletRequest request = this.setupHelloRequest(new String[0]);
        MockHttpServletResponse response = new MockHttpServletResponse();
        dispatcher.callbacks.add(callback);
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"{\"message\":\"hello\"}", (Object)response.getContentAsString());
        Assert.assertEquals((Object)TestDispatcherCallback.Status.FINISHED, callback.dispatcherStatus.get());
    }

    @Test
    public void testDispatcherCallbackOperationName() throws Exception {
        APIDispatcher dispatcher = this.getDispatcher();
        final AtomicReference requestReference = new AtomicReference();
        TestDispatcherCallback callback = new TestDispatcherCallback(){

            public Operation operationDispatched(Request request, Operation operation) {
                requestReference.set(request);
                return operation;
            }
        };
        MockHttpServletRequest request = this.setupHelloRequest(new String[0]);
        MockHttpServletResponse response = new MockHttpServletResponse();
        dispatcher.callbacks.add(callback);
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"Hello", (Object)((Request)requestReference.get()).getService());
        Assert.assertEquals((Object)"1.0", (Object)((Request)requestReference.get()).getVersion());
        Assert.assertEquals((Object)"sayHello", (Object)((Request)requestReference.get()).getRequest());
    }

    @Test
    public void testDispatcherCallbackFailInit() throws Exception {
        APIDispatcher dispatcher = this.getDispatcher();
        TestDispatcherCallback callback1 = new TestDispatcherCallback();
        TestDispatcherCallback callback2 = new TestDispatcherCallback();
        TestDispatcherCallback callbackFail = new TestDispatcherCallback(){

            public Request init(Request request) {
                this.dispatcherStatus.set(TestDispatcherCallback.Status.INIT);
                throw new RuntimeException("TestDispatcherCallbackFailInit");
            }
        };
        MockHttpServletRequest request = this.setupHelloRequest(new String[0]);
        MockHttpServletResponse response = new MockHttpServletResponse();
        dispatcher.callbacks.add(callback1);
        dispatcher.callbacks.add(callbackFail);
        dispatcher.callbacks.add(callback2);
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        this.checkInternalError(response, "{\"type\":\"NoApplicableCode\",\"title\":\"TestDispatcherCallbackFailInit\"}");
        Assert.assertEquals((Object)TestDispatcherCallback.Status.FINISHED, callback1.dispatcherStatus.get());
        Assert.assertEquals((Object)TestDispatcherCallback.Status.FINISHED, callbackFail.dispatcherStatus.get());
        Assert.assertEquals((Object)TestDispatcherCallback.Status.FINISHED, callback2.dispatcherStatus.get());
    }

    @Test
    public void testDispatcherCallbackFailServiceDispatched() throws Exception {
        APIDispatcher dispatcher = this.getDispatcher();
        TestDispatcherCallback callback1 = new TestDispatcherCallback();
        TestDispatcherCallback callback2 = new TestDispatcherCallback();
        TestDispatcherCallback callbackFail = new TestDispatcherCallback(){

            public Service serviceDispatched(Request request, Service service) {
                this.dispatcherStatus.set(TestDispatcherCallback.Status.SERVICE_DISPATCHED);
                throw new RuntimeException("TestDispatcherCallbackFailServiceDispatched");
            }
        };
        MockHttpServletRequest request = this.setupHelloRequest(new String[0]);
        MockHttpServletResponse response = new MockHttpServletResponse();
        dispatcher.callbacks.add(callback1);
        dispatcher.callbacks.add(callbackFail);
        dispatcher.callbacks.add(callback2);
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        this.checkInternalError(response, "{\"type\":\"NoApplicableCode\",\"title\":\"TestDispatcherCallbackFailServiceDispatched\"}");
        Assert.assertEquals((Object)TestDispatcherCallback.Status.FINISHED, callback1.dispatcherStatus.get());
        Assert.assertEquals((Object)TestDispatcherCallback.Status.FINISHED, callback2.dispatcherStatus.get());
    }

    @Test
    public void testDispatcherCallbackFailOperationDispatched() throws Exception {
        APIDispatcher dispatcher = this.getDispatcher();
        TestDispatcherCallback callback1 = new TestDispatcherCallback();
        TestDispatcherCallback callback2 = new TestDispatcherCallback();
        TestDispatcherCallback callbackFail = new TestDispatcherCallback(){

            public Operation operationDispatched(Request request, Operation operation) {
                this.dispatcherStatus.set(TestDispatcherCallback.Status.OPERATION_DISPATCHED);
                throw new RuntimeException("TestDispatcherCallbackFailOperationDispatched");
            }
        };
        MockHttpServletRequest request = this.setupHelloRequest(new String[0]);
        MockHttpServletResponse response = new MockHttpServletResponse();
        dispatcher.callbacks.add(callback1);
        dispatcher.callbacks.add(callbackFail);
        dispatcher.callbacks.add(callback2);
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        this.checkInternalError(response, "{\"type\":\"NoApplicableCode\",\"title\":\"TestDispatcherCallbackFailOperationDispatched\"}");
        Assert.assertEquals((Object)TestDispatcherCallback.Status.FINISHED, callback1.dispatcherStatus.get());
        Assert.assertEquals((Object)TestDispatcherCallback.Status.FINISHED, callback2.dispatcherStatus.get());
    }

    @Test
    public void testDispatcherCallbackFailOperationExecuted() throws Exception {
        APIDispatcher dispatcher = this.getDispatcher();
        TestDispatcherCallback callback1 = new TestDispatcherCallback();
        TestDispatcherCallback callback2 = new TestDispatcherCallback();
        TestDispatcherCallback callbackFail = new TestDispatcherCallback(){

            public Object operationExecuted(Request request, Operation operation, Object result) {
                this.dispatcherStatus.set(TestDispatcherCallback.Status.OPERATION_EXECUTED);
                throw new RuntimeException("TestDispatcherCallbackFailOperationExecuted");
            }
        };
        MockHttpServletRequest request = this.setupHelloRequest(new String[0]);
        MockHttpServletResponse response = new MockHttpServletResponse();
        dispatcher.callbacks.add(callback1);
        dispatcher.callbacks.add(callbackFail);
        dispatcher.callbacks.add(callback2);
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        this.checkInternalError(response, "{\"type\":\"NoApplicableCode\",\"title\":\"TestDispatcherCallbackFailOperationExecuted\"}");
        Assert.assertEquals((Object)TestDispatcherCallback.Status.FINISHED, callback1.dispatcherStatus.get());
        Assert.assertEquals((Object)TestDispatcherCallback.Status.FINISHED, callback2.dispatcherStatus.get());
    }

    @Test
    public void testDispatcherCallbackFailResponseDispatched() throws Exception {
        APIDispatcher dispatcher = this.getDispatcher();
        TestDispatcherCallback callback1 = new TestDispatcherCallback();
        TestDispatcherCallback callback2 = new TestDispatcherCallback();
        TestDispatcherCallback callbackFail = new TestDispatcherCallback(){

            public Response responseDispatched(Request request, Operation operation, Object result, Response response) {
                this.dispatcherStatus.set(TestDispatcherCallback.Status.RESPONSE_DISPATCHED);
                throw new RuntimeException("TestDispatcherCallbackFailResponseDispatched");
            }
        };
        MockHttpServletRequest request = this.setupHelloRequest(new String[0]);
        MockHttpServletResponse response = new MockHttpServletResponse();
        dispatcher.callbacks.add(callback1);
        dispatcher.callbacks.add(callbackFail);
        dispatcher.callbacks.add(callback2);
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        this.checkInternalError(response, "{\"type\":\"NoApplicableCode\",\"title\":\"TestDispatcherCallbackFailResponseDispatched\"}");
        Assert.assertEquals((Object)TestDispatcherCallback.Status.FINISHED, callback1.dispatcherStatus.get());
        Assert.assertEquals((Object)TestDispatcherCallback.Status.FINISHED, callback2.dispatcherStatus.get());
    }

    @Test
    public void testDispatcherCallbackFailFinished() throws Exception {
        APIDispatcher dispatcher = this.getDispatcher();
        final AtomicBoolean firedCallback = new AtomicBoolean(false);
        TestDispatcherCallback callback1 = new TestDispatcherCallback();
        TestDispatcherCallback callback2 = new TestDispatcherCallback(){

            public void finished(Request request) {
                firedCallback.set(true);
                super.finished(request);
            }
        };
        TestDispatcherCallback callbackFail = new TestDispatcherCallback(){

            public void finished(Request request) {
                this.dispatcherStatus.set(TestDispatcherCallback.Status.FINISHED);
                throw new Error("TestDispatcherCallbackFailFinished");
            }
        };
        MockHttpServletRequest request = this.setupHelloRequest(new String[0]);
        MockHttpServletResponse response = new MockHttpServletResponse();
        dispatcher.callbacks.add(callback1);
        dispatcher.callbacks.add(callbackFail);
        dispatcher.callbacks.add(callback2);
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        Assert.assertEquals((Object)"{\"message\":\"hello\"}", (Object)response.getContentAsString());
        Assert.assertTrue((boolean)firedCallback.get());
        Assert.assertEquals((Object)TestDispatcherCallback.Status.FINISHED, callback1.dispatcherStatus.get());
        Assert.assertEquals((Object)TestDispatcherCallback.Status.FINISHED, callback2.dispatcherStatus.get());
    }

    @Test
    public void testHttpErrorCodeException() throws Exception {
        this.assertHttpErrorCode("noContent", 204);
    }

    @Test
    public void testWrappedHttpErrorCodeException() throws Exception {
        this.assertHttpErrorCode("wrappedException", 204);
    }

    @Test
    public void testBadRequestHttpErrorCodeException() throws Exception {
        this.assertHttpErrorCode("badRequest", 400);
    }

    @Test
    public void testHttpErrorCodeExceptionWithContentType() throws Exception {
        CodeExpectingHttpServletResponse rsp = this.assertHttpErrorCode("errorWithPayload", 200);
        Assert.assertEquals((Object)"application/json", (Object)rsp.getContentType());
    }

    private CodeExpectingHttpServletResponse assertHttpErrorCode(String path, int expectedCode) throws Exception {
        APIDispatcher dispatcher = this.getDispatcher();
        MockHttpServletRequest request = this.setupRequestBase(new String[0]);
        request.setMethod("GET");
        request.setPathInfo("/geoserver/ogc/" + path);
        request.setRequestURI("/geoserver/ogc/" + path);
        CodeExpectingHttpServletResponse response = new CodeExpectingHttpServletResponse((HttpServletResponse)new MockHttpServletResponse());
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assert.assertEquals((long)expectedCode, (long)response.getStatusCode());
        Assert.assertEquals((Object)(expectedCode >= 400 ? 1 : 0), (Object)response.isError());
        return response;
    }

    private APIDispatcher getDispatcher() {
        return (APIDispatcher)this.applicationContext.getBean(APIDispatcher.class);
    }

    private MockHttpServletRequest setupDeleteRequest() {
        MockHttpServletRequest request = this.setupRequestBase(new String[0]);
        request.setPathInfo("/geoserver/ogc/delete");
        request.setRequestURI("/geoserver/ogc/delete");
        request.setMethod("DELETE");
        return request;
    }

    private MockHttpServletRequest setupPutRequest(String message, String ... params) {
        MockHttpServletRequest request = this.setupRequestBase(params);
        request.setPathInfo("/geoserver/ogc/default");
        request.setMethod("PUT");
        request.setRequestURI("/geoserver/ogc/default");
        request.setContent(message.getBytes(StandardCharsets.UTF_8));
        return request;
    }

    private MockHttpServletRequest setupEchoRequest(String message, String ... params) {
        MockHttpServletRequest request = this.setupRequestBase(params);
        request.setPathInfo("/geoserver/ogc/hello");
        request.setMethod("POST");
        request.setRequestURI("/geoserver/ogc/echo");
        request.setContent(message.getBytes(StandardCharsets.UTF_8));
        return request;
    }

    private MockHttpServletRequest setupHelloRequest(String ... params) {
        MockHttpServletRequest request = this.setupRequestBase(params);
        request.setPathInfo("/geoserver/ogc/hello");
        request.setMethod("GET");
        request.setRequestURI("/geoserver/ogc/hello");
        return request;
    }

    private MockHttpServletRequest setupRequestBase(String ... params) {
        MockHttpServletRequest request = new MockHttpServletRequest(){
            String encoding;

            public int getServerPort() {
                return 8080;
            }

            public String getCharacterEncoding() {
                return this.encoding;
            }

            public void setCharacterEncoding(String encoding) {
                this.encoding = encoding;
            }
        };
        request.setScheme("http");
        request.setServerName("localhost");
        request.setContextPath("/geoserver");
        request.setServletPath("/geoserver/ogc");
        if (params != null) {
            Map<String, String> map = APIDispatcherTest.toMap(params);
            map.forEach((k, v) -> request.addParameter(k, v));
            request.setQueryString(map.entrySet().stream().map(Object::toString).collect(Collectors.joining("&")));
        }
        RequestContextHolder.setRequestAttributes((RequestAttributes)new DispatcherServletWebRequest((HttpServletRequest)request));
        return request;
    }

    public static Map<String, String> toMap(String ... keyValues) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < keyValues.length; i += 2) {
            map.put(keyValues[i], keyValues[i + 1]);
        }
        return map;
    }

    private void checkInternalError(MockHttpServletResponse response, String s) throws UnsupportedEncodingException {
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertEquals((Object)s, (Object)response.getContentAsString());
    }
}

