/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geotools.api.feature.type.FeatureType;

public class PropertiesParser {
    ResourceInfo resource;

    public PropertiesParser(ResourceInfo resource) {
        this.resource = resource;
    }

    public List<String> parse(String spec) throws IOException {
        List<String> names = Arrays.stream(spec.split("\\s*,\\s*")).collect(Collectors.toList());
        this.validate(names);
        return names;
    }

    protected void validate(List<String> names) throws IOException {
        FeatureType schema;
        Set availableNames;
        if (this.resource instanceof FeatureTypeInfo && !(availableNames = (schema = ((FeatureTypeInfo)this.resource).getFeatureType()).getDescriptors().stream().map(p -> p.getName().getLocalPart()).collect(Collectors.toSet())).containsAll(names)) {
            throw new IOException("Names does not match schema");
        }
    }
}

