/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.OpenAPI;
import org.springframework.http.MediaType;
import org.springframework.http.converter.json.AbstractJackson2HttpMessageConverter;
import org.springframework.stereotype.Component;

@Component
public class OpenAPIMessageConverter
extends AbstractJackson2HttpMessageConverter {
    public static final String OPEN_API_MEDIA_TYPE_VALUE = "application/vnd.oai.openapi+json;version=3.0";
    public static final MediaType OPEN_API_MEDIA_TYPE = MediaType.parseMediaType((String)"application/vnd.oai.openapi+json;version=3.0");

    public OpenAPIMessageConverter() {
        super(OpenAPIMessageConverter.getMapper(), OPEN_API_MEDIA_TYPE);
    }

    public static ObjectMapper getMapper() {
        ObjectMapper mapper = Json.mapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.writer((PrettyPrinter)new DefaultPrettyPrinter());
        return mapper;
    }

    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        return OPEN_API_MEDIA_TYPE.isCompatibleWith(mediaType) && OpenAPI.class.isAssignableFrom(clazz);
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return (mediaType == null || OPEN_API_MEDIA_TYPE.isCompatibleWith(mediaType)) && OpenAPI.class.isAssignableFrom(clazz);
    }
}

