/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.SettingsInfo;
import org.geoserver.ogcapi.APIDispatcher;
import org.geoserver.ogcapi.APIService;
import org.geoserver.ogcapi.AbstractDocument;
import org.geoserver.ogcapi.Link;
import org.geoserver.ogcapi.LinkInfo;

public class LinkInfoConverter {
    public static void addLinksToDocument(AbstractDocument document, PublishedInfo publishedInfo, Class serviceClass) {
        if (publishedInfo instanceof LayerInfo) {
            LinkInfoConverter.addLinksToDocument(document, ((LayerInfo)publishedInfo).getResource(), serviceClass);
        }
    }

    public static void addLinksToDocument(AbstractDocument document, LayerGroupInfo group, Class serviceClass) {
        List links = (List)group.getMetadata().get("ogcApiLinks", List.class);
        LinkInfoConverter.addLinksToDocument(document, serviceClass, links);
    }

    public static void addLinksToDocument(AbstractDocument document, ResourceInfo resource, Class serviceClass) {
        List links = (List)resource.getMetadata().get("ogcApiLinks", List.class);
        LinkInfoConverter.addLinksToDocument(document, serviceClass, links);
    }

    public static void addLinksToDocument(AbstractDocument document, SettingsInfo settings, Class<?> serviceClass) {
        List links = (List)settings.getMetadata().get("ogcApiLinks", List.class);
        LinkInfoConverter.addLinksToDocument(document, serviceClass, links);
    }

    private static void addLinksToDocument(AbstractDocument document, Class serviceClass, List<LinkInfo> links) {
        if (links != null) {
            APIService annotation = APIDispatcher.getApiServiceAnnotation(serviceClass);
            String service = Optional.ofNullable(annotation).map(s -> s.service()).orElse(null);
            links.stream().filter(l -> LinkInfoConverter.serviceMatch(l, service)).forEach(l -> LinkInfoConverter.addLinkToDocument(l, document));
        }
    }

    private static void addLinkToDocument(LinkInfo l, AbstractDocument document) {
        document.addLink(LinkInfoConverter.toLink(l));
    }

    public static Link toLink(LinkInfo l) {
        return new Link(l.getHref(), l.getRel(), l.getType(), l.getTitle());
    }

    private static boolean serviceMatch(LinkInfo l, String service) {
        return l.getService() == null || Objects.equals(l.getService(), service);
    }
}

