/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.SettingsInfo;
import org.geoserver.ogcapi.AbstractCollectionDocument;
import org.geoserver.ogcapi.AbstractDocument;
import org.geoserver.ogcapi.DocumentCallback;
import org.geoserver.ogcapi.LinkInfoConverter;
import org.geoserver.ows.Request;
import org.geoserver.platform.Service;
import org.springframework.stereotype.Component;

@Component
public class LinkInfoCallback
implements DocumentCallback {
    GeoServer geoServer;

    public LinkInfoCallback(GeoServer geoServer) {
        this.geoServer = geoServer;
    }

    @Override
    public void apply(Request dr, AbstractDocument document) {
        if (document instanceof AbstractCollectionDocument) {
            this.decorateCollection(dr, (AbstractCollectionDocument)document);
        } else if (this.isCollectionsDocument(dr)) {
            this.decorateCollections(dr, document);
        }
    }

    private void decorateCollections(Request dr, AbstractDocument document) {
        Class<?> serviceClass = LinkInfoCallback.getServiceClass(dr);
        SettingsInfo settings = this.geoServer.getSettings();
        LinkInfoConverter.addLinksToDocument(document, settings, serviceClass);
    }

    private boolean isCollectionsDocument(Request dr) {
        return dr.getPath().equals("collections");
    }

    private void decorateCollection(Request dr, AbstractCollectionDocument document) {
        Object subject = document.getSubject();
        Class<?> serviceClass = LinkInfoCallback.getServiceClass(dr);
        if (subject instanceof ResourceInfo) {
            ResourceInfo resource = (ResourceInfo)subject;
            LinkInfoConverter.addLinksToDocument((AbstractDocument)document, resource, serviceClass);
        } else if (subject instanceof PublishedInfo) {
            PublishedInfo layer = (PublishedInfo)subject;
            LinkInfoConverter.addLinksToDocument((AbstractDocument)document, layer, serviceClass);
        }
    }

    private static Class<?> getServiceClass(Request dr) {
        Service service = dr.getOperation().getService();
        return service != null ? service.getService().getClass() : null;
    }
}

