/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geoserver.ogcapi.APIDispatcher;
import org.geoserver.ogcapi.APIService;
import org.geoserver.platform.Service;
import org.geotools.util.Version;
import org.geotools.util.logging.Logging;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class APIServiceFactoryBean
implements FactoryBean,
ApplicationContextAware {
    static final Logger LOGGER = Logging.getLogger(APIServiceFactoryBean.class);
    private final String serviceName;
    private final Version version;
    private Service service;

    public APIServiceFactoryBean(String serviceName, String version) {
        this.serviceName = serviceName;
        this.version = new Version(version);
    }

    public Object getObject() throws Exception {
        return this.service;
    }

    public Class<?> getObjectType() {
        return Service.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Object coreBean;
        List serviceBeans = applicationContext.getBeansWithAnnotation(APIService.class).values().stream().filter(bean -> {
            APIService annotation = APIDispatcher.getApiServiceAnnotation(bean.getClass());
            return this.serviceName.equalsIgnoreCase(annotation.service()) && this.version.equals((Object)new Version(annotation.version()));
        }).collect(Collectors.toList());
        if (serviceBeans.isEmpty()) {
            throw new RuntimeException("Was expecting a service bean marked with service name '" + this.serviceName + " and version " + this.version + "' but found none");
        }
        List coreBeans = serviceBeans.stream().filter(bean -> {
            APIService annotation = APIDispatcher.getApiServiceAnnotation(bean.getClass());
            return annotation.core();
        }).collect(Collectors.toList());
        if (coreBeans.isEmpty()) {
            LOGGER.log(Level.WARNING, "No is marked as 'core' for service " + this.serviceName + " a random one will be picked for OWS service compatibility.");
            coreBean = serviceBeans.get(0);
        } else {
            coreBean = coreBeans.get(0);
            if (coreBeans.size() > 1) {
                LOGGER.log(Level.WARNING, "More than one bean is marked as 'core' for service " + this.serviceName + " a random one will be picked for OWS service compatibility.");
            }
        }
        APIService annotation = coreBean.getClass().getAnnotation(APIService.class);
        List operations = serviceBeans.stream().flatMap(sb -> Arrays.stream(sb.getClass().getMethods())).filter(m -> APIDispatcher.hasRequestMapping(m)).map(m -> APIDispatcher.getOperationName(m)).distinct().sorted().collect(Collectors.toList());
        this.service = new Service(annotation.service(), coreBean, this.version, operations);
        this.service.setCustomCapabilitiesLink("../" + annotation.landingPage());
    }
}

