/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.geoserver.ogcapi.MappingJackson2YAMLMessageConverter;
import org.geoserver.ogcapi.OpenAPIMessageConverter;
import org.springframework.http.MediaType;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.accept.ContentNegotiationStrategy;
import org.springframework.web.accept.HeaderContentNegotiationStrategy;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;

public class APIContentNegotiationManager
extends ContentNegotiationManager {
    public APIContentNegotiationManager() {
        ArrayList<Object> strategies = new ArrayList<Object>();
        strategies.add(new FormatContentNegotiationStrategy());
        strategies.add(new OpenAPIContentNegotiationStrategy());
        strategies.add(new HeaderContentNegotiationStrategy());
        this.getStrategies().clear();
        this.getStrategies().addAll(strategies);
    }

    private class OpenAPIContentNegotiationStrategy
    implements ContentNegotiationStrategy {
        private OpenAPIContentNegotiationStrategy() {
        }

        public List<MediaType> resolveMediaTypes(NativeWebRequest nativeWebRequest) {
            if (nativeWebRequest instanceof ServletWebRequest) {
                ServletWebRequest servletWebRequest = (ServletWebRequest)nativeWebRequest;
                if (servletWebRequest.getRequest().getRequestURI().endsWith("/openapi.json")) {
                    return Arrays.asList(OpenAPIMessageConverter.OPEN_API_MEDIA_TYPE);
                }
                if (servletWebRequest.getRequest().getRequestURI().endsWith("/openapi.yaml")) {
                    return Arrays.asList(MappingJackson2YAMLMessageConverter.APPLICATION_YAML);
                }
            }
            return MEDIA_TYPE_ALL_LIST;
        }
    }

    private static class FormatContentNegotiationStrategy
    implements ContentNegotiationStrategy {
        private FormatContentNegotiationStrategy() {
        }

        public List<MediaType> resolveMediaTypes(NativeWebRequest webRequest) {
            String format = webRequest.getParameter("f");
            if ("json".equals(format)) {
                return Arrays.asList(MediaType.APPLICATION_JSON, MediaType.parseMediaType((String)"application/*+json"));
            }
            if ("xml".equals(format)) {
                return Arrays.asList(MediaType.APPLICATION_XML, MediaType.TEXT_XML);
            }
            if ("html".equals(format)) {
                return Collections.singletonList(MediaType.TEXT_HTML);
            }
            if ("yaml".equals(format)) {
                return Collections.singletonList(MappingJackson2YAMLMessageConverter.APPLICATION_YAML);
            }
            if (format != null) {
                return Collections.singletonList(MediaType.parseMediaType((String)format));
            }
            return MEDIA_TYPE_ALL_LIST;
        }
    }
}

