/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.util.XStreamPersisterFactory;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ogcapi.OGCApiTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class HelloServiceTrailingSlashOffTest
extends OGCApiTestSupport {
    protected void setUpTestData(SystemTestData testData) throws Exception {
        super.setUpTestData(testData);
        File root = testData.getDataDirectoryRoot();
        XStream xs = new XStreamPersisterFactory().createXMLPersister().getXStream();
        File file = new File(root, "global.xml");
        GeoServerInfo gs = (GeoServerInfo)xs.fromXML(file);
        gs.setTrailingSlashMatch(Boolean.valueOf(false));
        try (FileOutputStream fos = new FileOutputStream(file);){
            xs.toXML((Object)gs, (OutputStream)fos);
        }
    }

    @Test
    public void testLandingPageRegardlessTrailingSlash() throws Exception {
        DocumentContext doc = this.getAsJSONPath("ogc/hello/v1/", 200);
        Assert.assertEquals((Object)"Landing page", (Object)doc.read("message", new Predicate[0]));
        doc = this.getAsJSONPath("ogc/hello/v1", 200);
        Assert.assertEquals((Object)"Landing page", (Object)doc.read("message", new Predicate[0]));
    }

    @Test
    public void testWorkspaceLandingPageRegardlessTrailingSlash() throws Exception {
        DocumentContext doc = this.getAsJSONPath("cite/ogc/hello/v1/", 200);
        Assert.assertEquals((Object)"Landing page", (Object)doc.read("message", new Predicate[0]));
        doc = this.getAsJSONPath("cite/ogc/hello/v1", 200);
        Assert.assertEquals((Object)"Landing page", (Object)doc.read("message", new Predicate[0]));
        Assert.assertEquals((long)404L, (long)this.getAsServletResponse("abcd/ogc/hello/v1").getStatus());
    }

    @Test
    public void testLayerLandingPageRegardlessTrailingSlash() throws Exception {
        DocumentContext doc = this.getAsJSONPath("cite/BasicPolygons/ogc/hello/v1/", 200);
        Assert.assertEquals((Object)"Landing page", (Object)doc.read("message", new Predicate[0]));
        doc = this.getAsJSONPath("cite/BasicPolygons/ogc/hello/v1", 200);
        Assert.assertEquals((Object)"Landing page", (Object)doc.read("message", new Predicate[0]));
        Assert.assertEquals((long)404L, (long)this.getAsServletResponse("cite/abcd/ogc/hello/v1").getStatus());
    }

    @Test
    public void testHelloTrailingSlash() throws Exception {
        DocumentContext doc = this.getAsJSONPath("ogc/hello/v1/hello?message=abcd", 200);
        Assert.assertEquals((Object)"abcd", (Object)doc.read("message", new Predicate[0]));
        MockHttpServletResponse sr = this.getAsServletResponse("ogc/hello/v1/hello/?message=abcd");
        Assert.assertEquals((long)404L, (long)sr.getStatus());
        doc = this.getAsJSONPath(sr);
        Assert.assertEquals((Object)"ResourceNotFound", (Object)doc.read("type", new Predicate[0]));
        Assert.assertEquals((Object)"No mapping for GET /geoserver/ogc/hello/v1/hello/", (Object)doc.read("title", new Predicate[0]));
    }
}

