/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.ogcapi.AbstractDocument;
import org.geotools.styling.Description;
import org.geotools.util.logging.Logging;

@JsonPropertyOrder(value={"id", "title", "links"})
public class StyleDocument
extends AbstractDocument {
    public static final String DEFAULT_STYLE_NAME = "_";
    static final Logger LOGGER = Logging.getLogger(StyleDocument.class);
    String title;
    StyleInfo style;

    public StyleDocument(String id, String title) {
        this.id = id;
        this.title = title;
    }

    public StyleDocument(StyleInfo style) {
        this.style = style;
        this.id = style.prefixedName();
        try {
            this.title = Optional.ofNullable(style.getStyle().getDescription()).map(Description::getTitle).map(Object::toString).orElse(null);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not get description from style, setting it to null", e);
            this.title = null;
        }
    }

    public String getTitle() {
        return this.title;
    }

    @JsonIgnore
    public StyleInfo getStyle() {
        return this.style;
    }
}

