/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import io.swagger.v3.core.util.Yaml;
import java.lang.reflect.Type;
import org.geoserver.rest.wrapper.RestWrapper;
import org.springframework.http.MediaType;
import org.springframework.http.converter.json.AbstractJackson2HttpMessageConverter;

public class MappingJackson2YAMLMessageConverter
extends AbstractJackson2HttpMessageConverter {
    public static final String APPLICATION_YAML_VALUE = "application/x-yaml";
    public static final MediaType APPLICATION_YAML = MediaType.parseMediaType((String)"application/x-yaml");

    protected MappingJackson2YAMLMessageConverter() {
        super(Yaml.mapper(), APPLICATION_YAML);
    }

    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        if (!MappingJackson2YAMLMessageConverter.canJacksonHandle(clazz)) {
            return false;
        }
        return super.canRead(clazz, mediaType);
    }

    public boolean canRead(Type type, Class<?> contextClass, MediaType mediaType) {
        if (contextClass != null && !contextClass.getPackage().getName().startsWith("org.geoserver.ogcapi")) {
            return false;
        }
        return super.canRead(type, contextClass, mediaType);
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        if (!MappingJackson2YAMLMessageConverter.canJacksonHandle(clazz)) {
            return false;
        }
        return super.canWrite(clazz, mediaType);
    }

    static boolean canJacksonHandle(Class<?> clazz) {
        return clazz.getAnnotation(JsonIgnoreType.class) == null && !RestWrapper.class.isAssignableFrom(clazz);
    }
}

