/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import java.util.Arrays;
import org.geotools.factory.CommonFactoryFinder;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

@Component
public class SortByConverter
implements Converter<String, SortBy[]> {
    static final FilterFactory2 FF = CommonFactoryFinder.getFilterFactory2();

    public SortBy[] convert(String spec) {
        return (SortBy[])Arrays.stream(spec.split("\\s*,\\s*")).map(s -> this.sortBy((String)s)).toArray(SortBy[]::new);
    }

    private SortBy sortBy(String spec) {
        SortOrder order = SortOrder.ASCENDING;
        if (spec.startsWith("+")) {
            spec = spec.substring(1);
        } else if (spec.startsWith("-")) {
            spec = spec.substring(1);
            order = SortOrder.DESCENDING;
        }
        return FF.sort(spec, order);
    }
}

