/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ogcapi.Link;
import org.geoserver.ows.AbstractDispatcherCallback;
import org.geoserver.ows.Request;
import org.geoserver.ows.Response;
import org.geoserver.platform.Operation;
import org.geotools.util.logging.Logging;
import org.springframework.stereotype.Component;

@Component
public class HttpHeaderLinksAppender
extends AbstractDispatcherCallback {
    static final Logger LOGGER = Logging.getLogger(HttpHeaderLinksAppender.class);
    static final ThreadLocal<List<Link>> LINKS = ThreadLocal.withInitial(ArrayList::new);
    static final int MAX_LINKS_HEADER_SIZE = 2048;

    public static void addLink(Link link) {
        LINKS.get().add(link);
    }

    public Response responseDispatched(Request request, Operation operation, Object result, Response response) {
        APIRequestInfo ri = APIRequestInfo.get();
        if (ri == null) {
            return response;
        }
        HttpServletResponse httpResponse = ri.getResponse();
        List<Link> links = LINKS.get();
        if (links.isEmpty()) {
            return response;
        }
        List<String> allFormatted = links.stream().map(this::formatLink).collect(Collectors.toList());
        int size = this.getLinksHeaderSize(allFormatted);
        if (size < 2048) {
            allFormatted.forEach(l -> httpResponse.addHeader("Link", l));
        } else {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Headers are too large, would have been: " + allFormatted);
                LOGGER.fine("Providing only self/alternate links");
            }
            List<String> selfFormatted = links.stream().filter(l -> {
                String rel = l.getRel();
                return rel.equals("self") || rel.equals("alternate");
            }).map(this::formatLink).collect(Collectors.toList());
            selfFormatted.forEach(l -> httpResponse.addHeader("Link", l));
        }
        return response;
    }

    private int getLinksHeaderSize(List<String> allFormatted) {
        return allFormatted.stream().mapToInt(l -> l.getBytes().length).sum() + allFormatted.size() * 6;
    }

    String formatLink(Link link) {
        StringBuilder sb = new StringBuilder("<").append(link.getHref()).append(">");
        if (link.getRel() != null) {
            sb.append("; rel=\"").append(link.getRel()).append("\"");
        }
        if (link.getType() != null) {
            sb.append("; type=\"").append(link.getType()).append("\"");
        }
        if (link.getTitle() != null) {
            sb.append("; title=\"").append(link.getTitle()).append("\"");
        }
        return sb.toString();
    }

    public void finished(Request request) {
        LINKS.remove();
    }
}

