/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.geoserver.ogcapi.AttributeType;
import org.geotools.filter.FunctionFinder;
import org.opengis.filter.capability.FunctionName;
import org.opengis.geometry.Geometry;
import org.opengis.parameter.Parameter;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FunctionsDocument {
    public static final String REL = "http://www.opengis.net/def/rel/ogc/1.0/functions";
    List<Function> functions = new FunctionFinder(null).getAllFunctionDescriptions().stream().filter(FunctionsDocument::isSimpleFunction).map(Function::new).distinct().collect(Collectors.toList());

    private static Argument toParameter(Parameter<?> parameter) {
        return new Argument(parameter.getName(), Optional.ofNullable(parameter.getDescription()).map(d -> d.toString()).orElse(null), new AttributeType[]{AttributeType.fromClass(parameter.getType())});
    }

    private static boolean isSimpleFunction(FunctionName functionName) {
        for (Parameter p : functionName.getArguments()) {
            Class type = p.getType();
            if (type == null) {
                return false;
            }
            if (CharSequence.class.isAssignableFrom(type) || Number.class.isAssignableFrom(type) || Date.class.isAssignableFrom(type) || org.locationtech.jts.geom.Geometry.class.isAssignableFrom(type) || Geometry.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type)) continue;
            return false;
        }
        return true;
    }

    public List<Function> getFunctions() {
        return this.functions;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Function {
        String name;
        String description;
        Argument returns;
        List<Argument> arguments;

        Function(FunctionName fn) {
            this.name = fn.getName();
            this.returns = FunctionsDocument.toParameter(fn.getReturn());
            this.description = null;
            this.arguments = fn.getArguments().stream().map(x$0 -> FunctionsDocument.toParameter(x$0)).collect(Collectors.toList());
        }

        public String getName() {
            return this.name;
        }

        public Argument getReturns() {
            return this.returns;
        }

        public List<Argument> getArguments() {
            return this.arguments;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Argument {
        String title;
        String description;
        AttributeType[] type;

        public Argument(String title, String description, AttributeType[] type) {
            this.title = title;
            this.description = description;
            this.type = type;
        }

        public String getTitle() {
            return this.title;
        }

        public String getDescription() {
            return this.description;
        }

        public AttributeType[] getType() {
            return this.type;
        }
    }
}

