/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.http.MediaType;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.accept.ContentNegotiationStrategy;
import org.springframework.web.accept.HeaderContentNegotiationStrategy;
import org.springframework.web.context.request.NativeWebRequest;

public class APIContentNegotiationManager
extends ContentNegotiationManager {
    public APIContentNegotiationManager() {
        ArrayList<FormatContentNegotiationStrategy> strategies = new ArrayList<FormatContentNegotiationStrategy>();
        strategies.add(new FormatContentNegotiationStrategy());
        strategies.add((FormatContentNegotiationStrategy)new HeaderContentNegotiationStrategy());
        this.getStrategies().clear();
        this.getStrategies().addAll(strategies);
    }

    private static class FormatContentNegotiationStrategy
    implements ContentNegotiationStrategy {
        private FormatContentNegotiationStrategy() {
        }

        public List<MediaType> resolveMediaTypes(NativeWebRequest webRequest) throws HttpMediaTypeNotAcceptableException {
            String format = webRequest.getParameter("f");
            if ("json".equals(format)) {
                return Arrays.asList(MediaType.APPLICATION_JSON, MediaType.parseMediaType((String)"application/*+json"));
            }
            if ("xml".equals(format)) {
                return Arrays.asList(MediaType.APPLICATION_XML, MediaType.TEXT_XML);
            }
            if ("html".equals(format)) {
                return Collections.singletonList(MediaType.TEXT_HTML);
            }
            if (format != null) {
                return Collections.singletonList(MediaType.parseMediaType((String)format));
            }
            return MEDIA_TYPE_ALL_LIST;
        }
    }
}

