/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.logging.Logger;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.DispatcherCallback;
import org.geoserver.ows.Request;
import org.geoserver.platform.Operation;
import org.geoserver.rest.RestConfiguration;
import org.geotools.util.logging.Logging;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.ServletInvocableHandlerMethod;

@Component
public class APIConfigurationSupport
extends RestConfiguration {
    static final Logger LOGGER = Logging.getLogger((String)"org.geoserver.ogcapi");
    List<DispatcherCallback> callbacks;

    protected RequestMappingHandlerAdapter createRequestMappingHandlerAdapter() {
        return new APIRequestMappingHandlerAdapter();
    }

    public List<DispatcherCallback> getCallbacks() {
        return this.callbacks;
    }

    public void setCallbacks(List<DispatcherCallback> callbacks) {
        this.callbacks = callbacks;
    }

    Operation fireOperationDispatchedCallback(Request req, Operation op) {
        for (DispatcherCallback cb : this.callbacks) {
            Operation o = cb.operationDispatched(req, op);
            op = o != null ? o : op;
        }
        return op;
    }

    class APIInvocableHandlerMethod
    extends ServletInvocableHandlerMethod {
        public APIInvocableHandlerMethod(HandlerMethod handlerMethod) {
            super(handlerMethod);
        }

        protected Object doInvoke(Object ... args) throws Exception {
            Request request = (Request)Dispatcher.REQUEST.get();
            if (request == null) {
                return super.doInvoke(args);
            }
            Operation operation = new Operation(request.getRequest(), request.getServiceDescriptor(), this.getBridgedMethod(), args);
            operation = APIConfigurationSupport.this.fireOperationDispatchedCallback(request, operation);
            request.setOperation(operation);
            try {
                return operation.getMethod().invoke(operation.getService().getService(), operation.getParameters());
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                if (targetException instanceof RuntimeException) {
                    throw (RuntimeException)targetException;
                }
                if (targetException instanceof Error) {
                    throw (Error)targetException;
                }
                if (targetException instanceof Exception) {
                    throw (Exception)targetException;
                }
                throw new IllegalStateException(e);
            }
        }
    }

    class APIRequestMappingHandlerAdapter
    extends RequestMappingHandlerAdapter {
        APIRequestMappingHandlerAdapter() {
        }

        protected ServletInvocableHandlerMethod createInvocableHandlerMethod(HandlerMethod handlerMethod) {
            return new APIInvocableHandlerMethod(handlerMethod);
        }
    }
}

