/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.ogcapi.APIService;
import org.geoserver.ows.LocalWorkspace;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.template.DirectTemplateFeatureCollectionFactory;
import org.geoserver.template.FeatureWrapper;
import org.geoserver.template.GeoServerTemplateLoader;
import org.geoserver.template.TemplateUtils;
import org.geotools.util.SoftValueHashMap;
import org.springframework.stereotype.Component;

@Component
public class FreemarkerTemplateSupport {
    private static final Map<Class<?>, Configuration> configurationCache = new SoftValueHashMap(10);
    private final GeoServerResourceLoader resourceLoader;
    ClassTemplateLoader rootLoader = new ClassTemplateLoader(FreemarkerTemplateSupport.class, "");
    static DirectTemplateFeatureCollectionFactory FC_FACTORY = new DirectTemplateFeatureCollectionFactory();

    public FreemarkerTemplateSupport(GeoServerResourceLoader loader) {
        this.resourceLoader = loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Template getTemplate(ResourceInfo resource, String templateName, final Class<?> clazz) throws IOException {
        Configuration configuration;
        GeoServerTemplateLoader templateLoader = new GeoServerTemplateLoader(clazz, this.resourceLoader){

            public Object findTemplateSource(String path) throws IOException {
                Object source = null;
                APIService service = clazz.getAnnotation(APIService.class);
                if (service != null) {
                    source = super.findTemplateSource(service.landingPage() + "/" + path);
                }
                if (source == null) {
                    source = super.findTemplateSource(path);
                }
                if (source == null && (source = FreemarkerTemplateSupport.this.rootLoader.findTemplateSource(path)) != null) {
                    return new GeoServerTemplateLoader.ClassTemplateSource(path, source);
                }
                return source;
            }
        };
        if (resource != null) {
            templateLoader.setResource(resource);
        } else {
            WorkspaceInfo ws = LocalWorkspace.get();
            if (ws != null) {
                templateLoader.setWorkspace(ws);
            }
        }
        Configuration configuration2 = configuration = this.getTemplateConfiguration(clazz);
        synchronized (configuration2) {
            configuration.setTemplateLoader((TemplateLoader)templateLoader);
            Template t = configuration.getTemplate(templateName);
            return t;
        }
    }

    Configuration getTemplateConfiguration(Class<?> clazz) {
        return configurationCache.computeIfAbsent(clazz, k -> {
            Configuration cfg = TemplateUtils.getSafeConfiguration();
            cfg.setDefaultEncoding(StandardCharsets.UTF_8.name());
            cfg.setObjectWrapper((ObjectWrapper)new FeatureWrapper((FeatureWrapper.TemplateFeatureCollectionFactory)FC_FACTORY));
            return cfg;
        });
    }

    public void processTemplate(ResourceInfo resource, String templateName, Class<?> referenceClass, Map<String, Object> model, Writer writer) throws IOException {
        Template template = this.getTemplate(resource, templateName, referenceClass);
        try {
            template.process(model, writer);
        }
        catch (TemplateException e) {
            throw new IOException("Error occured processing template " + templateName, e);
        }
    }

    public String processTemplate(ResourceInfo resource, String templateName, Class<?> referenceClass, Map<String, Object> model) throws IOException {
        StringWriter sw = new StringWriter();
        this.processTemplate(resource, templateName, referenceClass, model, sw);
        return sw.toString();
    }
}

