/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.internal.JsonContext;
import com.jayway.jsonpath.internal.JsonFormatter;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.ServletException;
import net.minidev.json.JSONAware;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.geoserver.data.test.CiteTestData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.filters.SpringDelegatingFilter;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.springframework.mock.web.MockHttpServletResponse;

public class OGCApiTestSupport
extends GeoServerSystemTestSupport {
    protected List<Filter> getFilters() {
        try {
            SpringDelegatingFilter filter = new SpringDelegatingFilter();
            filter.init(null);
            return Collections.singletonList(filter);
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
    }

    protected DocumentContext getAsJSONPath(String path, int expectedHttpCode) throws Exception {
        MockHttpServletResponse response = this.getAsMockHttpServletResponse(path, expectedHttpCode);
        return this.getAsJSONPath(response);
    }

    protected DocumentContext postAsJSONPath(String path, String body, int expectedHttpCode) throws Exception {
        MockHttpServletResponse response = this.postAsServletResponse(path, body, "application/json");
        Assert.assertEquals((long)expectedHttpCode, (long)response.getStatus());
        return this.getAsJSONPath(response);
    }

    protected DocumentContext getAsJSONPath(MockHttpServletResponse response) throws UnsupportedEncodingException {
        MatcherAssert.assertThat((Object)response.getContentType(), (Matcher)Matchers.containsString((String)"json"));
        JsonContext json = (JsonContext)JsonPath.parse((String)response.getContentAsString());
        if (!OGCApiTestSupport.isQuietTests()) {
            this.print(this.json(response));
        }
        return json;
    }

    protected MockHttpServletResponse getAsMockHttpServletResponse(String path, int expectedHttpCode) throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse(path);
        Assert.assertEquals((long)expectedHttpCode, (long)response.getStatus());
        return response;
    }

    protected void onSetUp(SystemTestData testData) throws Exception {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("atom", "http://www.w3.org/2005/Atom");
        namespaces.put("ogc", "http://www.opengis.net/ogc");
        this.registerNamespaces(namespaces);
        CiteTestData.registerNamespaces(namespaces);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
    }

    protected void registerNamespaces(Map<String, String> namespaces) {
    }

    protected byte[] getAsByteArray(String url) throws Exception {
        MockHttpServletResponse response = this.getAsMockHttpServletResponse(url, 200);
        return response.getContentAsByteArray();
    }

    protected JsonContext convertYamlToJsonPath(String yaml) throws Exception {
        ObjectMapper yamlReader = new ObjectMapper((JsonFactory)new YAMLFactory());
        Object obj = yamlReader.readValue(yaml, Object.class);
        ObjectMapper jsonWriter = new ObjectMapper();
        JsonContext json = (JsonContext)JsonPath.parse((String)jsonWriter.writeValueAsString(obj));
        return json;
    }

    protected <T> T readSingle(DocumentContext json, String path) {
        List items = (List)json.read(path, new Predicate[0]);
        Assert.assertEquals((String)("Found " + items.size() + " items for this path, but was expecting one: " + path + "\n" + items), (long)1L, (long)items.size());
        return (T)items.get(0);
    }

    protected DocumentContext readContext(DocumentContext ctx, String path) {
        JSONAware result = (JSONAware)ctx.read(path, JSONAware.class, new Predicate[0]);
        return JsonPath.parse((String)result.toJSONString());
    }

    protected DocumentContext readSingleContext(DocumentContext ctx, String path) {
        List list = (List)ctx.read(path, List.class, new Predicate[0]);
        if (list.size() != 1) {
            throw new RuntimeException("Was expecting to get an array of one, but got " + list.size() + " elements instead");
        }
        String array = ((JSONAware)ctx.read(path, JSONAware.class, new Predicate[0])).toJSONString();
        int opening = array.indexOf("[");
        int closing = array.lastIndexOf("]");
        String content = array.substring(opening + 1, closing);
        return JsonPath.parse((String)content);
    }

    protected void print(DocumentContext json) {
        if (OGCApiTestSupport.isQuietTests()) {
            return;
        }
        System.out.println(JsonFormatter.prettyPrint((String)json.jsonString()));
    }

    protected boolean exists(DocumentContext json, String path) {
        try {
            List items = (List)json.read(path, new Predicate[0]);
            return !items.isEmpty();
        }
        catch (PathNotFoundException e) {
            return false;
        }
    }

    protected <T> void assertJSONList(DocumentContext json, String path, T ... expected) {
        List selfRels = (List)json.read(path, new Predicate[0]);
        MatcherAssert.assertThat((Object)selfRels, (Matcher)Matchers.containsInAnyOrder((Object[])expected));
    }
}

