/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import java.io.IOException;
import java.util.Date;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.util.ReaderDimensionsAccessor;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.data.FeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.MaxVisitor;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.util.DateRange;
import org.opengis.feature.FeatureVisitor;

public class TimeExtentCalculator {
    private TimeExtentCalculator() {
    }

    public static DateRange getTimeExtent(ResourceInfo ri) throws IOException {
        DimensionInfo time = (DimensionInfo)ri.getMetadata().get("time", DimensionInfo.class);
        if (time == null) {
            return null;
        }
        if (ri instanceof FeatureTypeInfo) {
            return TimeExtentCalculator.getTimeExtent((FeatureTypeInfo)ri, time);
        }
        return TimeExtentCalculator.getTimeExtent((CoverageInfo)ri, time);
    }

    private static DateRange getTimeExtent(FeatureTypeInfo ft, DimensionInfo time) throws IOException {
        FeatureSource fs = ft.getFeatureSource(null, null);
        FeatureCollection collection = fs.getFeatures();
        MinVisitor min = new MinVisitor(time.getAttribute());
        collection.accepts((FeatureVisitor)min, null);
        CalcResult minResult = min.getResult();
        if (minResult != CalcResult.NULL_RESULT) {
            Date minDate = (Date)min.getMin();
            MaxVisitor max = new MaxVisitor(time.getAttribute());
            collection.accepts((FeatureVisitor)max, null);
            Date maxDate = (Date)max.getMax();
            if (minDate != null && maxDate != null) {
                return new DateRange(minDate, maxDate);
            }
        }
        return null;
    }

    private static DateRange getTimeExtent(CoverageInfo ci, DimensionInfo time) throws IOException {
        ReaderDimensionsAccessor accessor = new ReaderDimensionsAccessor((GridCoverage2DReader)ci.getGridCoverageReader(null, null));
        Date minTime = accessor.getMinTime();
        Date maxTime = accessor.getMaxTime();
        return new DateRange(minTime, maxTime);
    }
}

