/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;

public class PaginationLinksBuilder {
    private final String path;
    private final long startIndex;
    private final int maxFeatures;
    private final int returned;
    private final long matched;

    public PaginationLinksBuilder(String path, long startIndex, int limit, int returned, long matched) {
        this.path = path;
        this.startIndex = startIndex;
        this.maxFeatures = limit;
        this.returned = returned;
        this.matched = matched;
    }

    public String getPrevious() {
        Map<String, Object> kvp = this.getPreviousMap(true);
        if (kvp == null) {
            return null;
        }
        return this.buildURL(kvp);
    }

    public Map<String, Object> getPreviousMap(boolean includeQueryMap) {
        if (this.startIndex <= 0L) {
            return null;
        }
        LinkedHashMap<String, Object> kvp = new LinkedHashMap<String, Object>();
        if (includeQueryMap) {
            kvp.putAll(APIRequestInfo.get().getSimpleQueryMap());
        }
        long prevOffset = Math.max(this.startIndex - (long)this.maxFeatures, 0L);
        kvp.put("startIndex", prevOffset);
        kvp.put("limit", this.startIndex - prevOffset);
        return kvp;
    }

    public String getNext() {
        Map<String, Object> kvp = this.getNextMap(true);
        if (kvp == null) {
            return null;
        }
        return this.buildURL(kvp);
    }

    public Map<String, Object> getNextMap(boolean includeQueryMap) {
        if (this.returned == 0 || this.startIndex + (long)this.returned >= this.matched) {
            return null;
        }
        LinkedHashMap<String, Object> kvp = new LinkedHashMap<String, Object>();
        if (includeQueryMap) {
            kvp.putAll(APIRequestInfo.get().getSimpleQueryMap());
        }
        kvp.put("startIndex", this.startIndex + (long)this.returned);
        kvp.put("limit", this.maxFeatures);
        return kvp;
    }

    public String getSelf() {
        HttpServletRequest request = APIRequestInfo.get().getRequest();
        StringBuffer sb = request.getRequestURL();
        String queryString = request.getQueryString();
        if (queryString != null && !queryString.isEmpty()) {
            sb.append("?").append(queryString);
        }
        return sb.toString();
    }

    private String buildURL(Map<String, Object> kvp) {
        LinkedHashMap<String, String> kvps = new LinkedHashMap<String, String>();
        for (Map.Entry<String, Object> e : kvp.entrySet()) {
            kvps.put(e.getKey(), Optional.ofNullable(e.getValue()).map(v -> String.valueOf(v)).orElse(null));
        }
        return ResponseUtils.buildURL((String)APIRequestInfo.get().getBaseURL(), (String)this.path, kvps, (URLMangler.URLType)URLMangler.URLType.SERVICE);
    }
}

