/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.ows.Response;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.Operation;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class MessageConverterResponseAdapter<T>
implements HttpMessageConverter<T>,
ApplicationContextAware {
    protected final Class<T> valueClass;
    protected final Class<?> responseBinding;
    protected List<Response> responses;
    protected List<MediaType> supportedMediaTypes;

    public MessageConverterResponseAdapter(Class<T> valueClass, Class<?> responseBinding) {
        this.valueClass = valueClass;
        this.responseBinding = responseBinding;
    }

    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        return false;
    }

    public boolean canWrite(Class<?> aClass, MediaType mediaType) {
        return this.valueClass.isAssignableFrom(aClass) && (mediaType == null || this.getResponse(mediaType).isPresent());
    }

    public List<MediaType> getSupportedMediaTypes() {
        return this.supportedMediaTypes;
    }

    public T read(Class<? extends T> aClass, HttpInputMessage httpInputMessage) throws IOException, HttpMessageNotReadableException {
        throw new UnsupportedOperationException();
    }

    public void write(T value, MediaType mediaType, HttpOutputMessage httpOutputMessage) throws IOException, HttpMessageNotWritableException {
        Optional<Response> response = this.getResponse(mediaType);
        if (!response.isPresent()) {
            throw new IllegalArgumentException("Could not find a Response handling " + mediaType + " for binding " + this.valueClass);
        }
        Request dr = (Request)Dispatcher.REQUEST.get();
        Operation operation = this.getOperation(value, dr, mediaType);
        this.writeResponse(value, httpOutputMessage, operation, response.get());
    }

    protected void writeResponse(T value, HttpOutputMessage httpOutputMessage, Operation operation, Response response) throws IOException {
        this.setHeaders(value, operation, response, httpOutputMessage);
        response.write(value, httpOutputMessage.getBody(), operation);
    }

    protected Operation getOperation(T result, Request dr, MediaType mediaType) {
        return dr.getOperation();
    }

    public Optional<Response> getResponse(MediaType mediaType) {
        Object result = APIRequestInfo.get().getResult();
        Request dr = (Request)Dispatcher.REQUEST.get();
        Operation originalOperation = dr.getOperation();
        Operation op = result != null ? this.getOperation(result, dr, mediaType) : originalOperation;
        Predicate<MediaType> matchMediaType = mt -> mediaType.isCompatibleWith(mt);
        Predicate<Response> matchResponse = r -> r.canHandle(op) && (this.getMediaTypeStream((Response)r).anyMatch(matchMediaType) || r.getBinding().isInstance(result));
        return this.responses.stream().filter(matchResponse).findFirst();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Predicate<Response> predicate = this.getResponseFilterPredicate();
        this.responses = GeoServerExtensions.extensions(Response.class, (ApplicationContext)applicationContext).stream().filter(predicate).collect(Collectors.toList());
        this.supportedMediaTypes = this.responses.stream().flatMap(r -> this.getMediaTypeStream((Response)r)).distinct().collect(Collectors.toList());
    }

    protected Predicate<Response> getResponseFilterPredicate() {
        return r -> this.responseBinding.isAssignableFrom(r.getBinding());
    }

    protected Stream<MediaType> getMediaTypeStream(Response r) {
        return r.getOutputFormats().stream().filter(f -> f.contains("/")).filter(f -> {
            try {
                MediaType.parseMediaType((String)f);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }).map(f -> MediaType.parseMediaType((String)f));
    }

    protected void setHeaders(Object result, Operation operation, Response response, HttpOutputMessage message) {
        String disposition = response.getPreferredDisposition(result, operation);
        String filename = response.getAttachmentFileName(result, operation);
        Request request = (Request)Dispatcher.REQUEST.get();
        if (request != null && request.getRawKvp() != null) {
            Map rawKvp = request.getRawKvp();
            if (rawKvp.get("FILENAME") != null) {
                filename = (String)rawKvp.get("FILENAME");
            }
            if (rawKvp.get("CONTENT-DISPOSITION") != null) {
                disposition = (String)rawKvp.get("CONTENT-DISPOSITION");
            }
        }
        if (disposition != null && !"attachment".equals(disposition) && !"inline".equals(disposition)) {
            disposition = null;
        }
        String[][] headers = response.getHeaders(result, operation);
        boolean contentDispositionProvided = false;
        if (headers != null) {
            for (String[] header : headers) {
                if (header[0].equalsIgnoreCase("Content-Disposition")) {
                    contentDispositionProvided = true;
                    if (disposition != null) continue;
                    message.getHeaders().set(header[0], header[1]);
                    continue;
                }
                message.getHeaders().set(header[0], header[1]);
            }
        }
        if (!contentDispositionProvided) {
            if (disposition == null) {
                disposition = "inline";
            }
            String disp = disposition + "; filename=" + filename;
            message.getHeaders().set("Content-Disposition", disp);
        }
    }
}

