/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.config.GeoServer;
import org.geoserver.ogcapi.APIException;
import org.geoserver.ogcapi.APIExceptionHandler;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.platform.ExtensionPriority;
import org.geoserver.platform.OWS20Exception;
import org.geoserver.platform.ServiceException;
import org.geotools.util.logging.Logging;
import org.springframework.stereotype.Component;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

@Component
public class DefaultAPIExceptionHandler
implements APIExceptionHandler,
ExtensionPriority {
    private static final Logger LOGGER = Logging.getLogger(DefaultAPIExceptionHandler.class);
    protected GeoServer geoServer;

    public DefaultAPIExceptionHandler(GeoServer geoServer) {
        this.geoServer = geoServer;
    }

    @Override
    public boolean canHandle(Throwable t, APIRequestInfo request) {
        return true;
    }

    @Override
    public void handle(Throwable t, HttpServletResponse response) {
        response.setContentType("application/json");
        String code = null;
        boolean statusSet = false;
        String description = null;
        if (t instanceof OWS20Exception) {
            OWS20Exception ex = (OWS20Exception)t;
            if (ex.getHttpCode() != null) {
                response.setStatus(ex.getHttpCode().intValue());
                statusSet = true;
            }
        } else if (t instanceof OWS20Exception) {
            OWS20Exception t2 = (OWS20Exception)t;
            response.setStatus(t2.getHttpCode().intValue());
            code = t2.getCode();
            statusSet = true;
        } else if (t instanceof ServiceException) {
            code = ((ServiceException)t).getCode();
            OWS20Exception.OWSExceptionCode o20Code = OWS20Exception.OWSExceptionCode.getByCode((String)code);
            if (o20Code != null) {
                response.setStatus(o20Code.getHttpCode().intValue());
                statusSet = true;
            }
        } else if (t instanceof APIException) {
            APIException ae = (APIException)t;
            response.setStatus(ae.getStatus().value());
            statusSet = true;
            code = ae.getCode();
        } else if (t instanceof MethodArgumentTypeMismatchException) {
            response.setStatus(400);
            statusSet = true;
            code = "InvalidParameterValue";
            description = "Invalid syntax " + ((MethodArgumentTypeMismatchException)t).getValue() + " for parameter " + ((MethodArgumentTypeMismatchException)t).getParameter().getParameterName();
        }
        if (!statusSet) {
            response.setStatus(500);
        }
        if (code == null) {
            code = "NoApplicableCode";
        }
        if (description == null) {
            description = this.getDescription(t);
        }
        this.writeResponse(response, code, description);
    }

    protected void writeResponse(HttpServletResponse response, String code, String description) {
        LinkedHashMap<String, String> error = new LinkedHashMap<String, String>();
        error.put("code", code);
        error.put("description", description);
        try (ServletOutputStream os = response.getOutputStream();){
            ObjectMapper mapper = new ObjectMapper();
            mapper.writeValue((OutputStream)os, error);
            os.flush();
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, "Problem writing exception information back to calling client:", ex);
        }
    }

    protected String getDescription(Throwable t) {
        StringBuffer sb = new StringBuffer();
        OwsUtils.dumpExceptionMessages((Throwable)t, (StringBuffer)sb, (boolean)false);
        if (this.geoServer.getSettings().isVerboseExceptions()) {
            ByteArrayOutputStream stackTrace = new ByteArrayOutputStream();
            t.printStackTrace(new PrintStream(stackTrace));
            sb.append("\nDetails:\n");
            sb.append(new String(stackTrace.toByteArray()));
        }
        return sb.toString();
    }

    public int getPriority() {
        return 100;
    }
}

