/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import io.swagger.v3.oas.models.OpenAPI;
import java.util.function.BiConsumer;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ogcapi.AbstractDocument;
import org.geoserver.ogcapi.AbstractLandingPageDocument;
import org.geoserver.ogcapi.Link;
import org.springframework.http.MediaType;

public class AbstractLandingPageDocumentNoConformance
extends AbstractDocument {
    final String title;
    final String description;

    public AbstractLandingPageDocumentNoConformance(String title, String description, String serviceBase) {
        final APIRequestInfo requestInfo = APIRequestInfo.get();
        this.addLinksFor(serviceBase + "/", AbstractLandingPageDocument.class, "This document as ", "landingPage", new BiConsumer<MediaType, Link>(){
            boolean first = true;

            @Override
            public void accept(MediaType mediaType, Link link) {
                if (this.first && requestInfo.isFormatRequested(mediaType, MediaType.APPLICATION_JSON)) {
                    link.setRel("self");
                    link.setTitle("This document");
                    this.first = false;
                }
            }
        }, "alternate");
        this.addLinksFor(serviceBase + "/api", OpenAPI.class, "API definition for this endpoint as ", "api", (format, link) -> {
            if (MediaType.TEXT_HTML.equals(format)) {
                link.setRel("service-doc");
            }
        }, "service-desc");
        this.title = title;
        this.description = description;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }
}

