/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.utility.DeepUnwrap;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ogcapi.FreemarkerTemplateSupport;
import org.geoserver.ogcapi.HTMLExtensionCallback;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geotools.util.logging.Logging;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;

public abstract class AbstractHTMLMessageConverter<T>
extends AbstractHttpMessageConverter<T> {
    static final Logger LOGGER = Logging.getLogger(AbstractHTMLMessageConverter.class);
    protected final Class<?> binding;
    protected final GeoServer geoServer;
    protected final FreemarkerTemplateSupport templateSupport;
    protected final Class<? extends ServiceInfo> serviceConfigurationClass;

    public AbstractHTMLMessageConverter(Class<?> binding, Class<? extends ServiceInfo> serviceConfigurationClass, FreemarkerTemplateSupport templateSupport, GeoServer geoServer) {
        super(MediaType.TEXT_HTML);
        this.binding = binding;
        this.geoServer = geoServer;
        this.serviceConfigurationClass = serviceConfigurationClass;
        this.templateSupport = templateSupport;
    }

    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        return false;
    }

    protected boolean supports(Class<?> clazz) {
        return this.binding.isAssignableFrom(clazz);
    }

    protected T readInternal(Class<? extends T> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        throw new UnsupportedOperationException("HTML message conveters can only write HTML");
    }

    protected HashMap<String, Object> setupModel(Object value) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("model", value);
        model.put("service", this.geoServer.getService(this.serviceConfigurationClass));
        model.put("contact", this.geoServer.getGlobal().getSettings().getContact());
        String baseURL = this.getBaseURL();
        model.put("baseURL", baseURL);
        this.addLinkFunctions(baseURL, model);
        return model;
    }

    protected void addLinkFunctions(String baseURL, final Map<String, Object> model) {
        model.put("serviceLink", arguments -> {
            APIRequestInfo requestInfo = APIRequestInfo.get();
            return ResponseUtils.buildURL((String)requestInfo.getBaseURL(), (String)ResponseUtils.appendPath((String[])new String[]{requestInfo.getServiceLandingPage(), (String)arguments.get(0)}), arguments.size() > 1 ? Collections.singletonMap("f", arguments.get(1).toString()) : null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
        });
        model.put("resourceLink", arguments -> ResponseUtils.buildURL((String)baseURL, (String)((String)arguments.get(0)), null, (URLMangler.URLType)URLMangler.URLType.RESOURCE));
        model.put("externalLink", arguments -> ResponseUtils.buildURL((String)baseURL, (String)((String)arguments.get(0)), null, (URLMangler.URLType)URLMangler.URLType.EXTERNAL));
        model.put("htmlExtensions", new TemplateMethodModelEx(){

            public Object exec(List arguments) throws TemplateModelException {
                if (arguments != null) {
                    arguments = AbstractHTMLMessageConverter.this.unwrapArguments(arguments);
                }
                return AbstractHTMLMessageConverter.this.processHtmlExtensions(model, arguments);
            }
        });
    }

    public List<Object> unwrapArguments(List<Object> arguments) {
        return arguments.stream().map(v -> {
            if (v instanceof TemplateModel) {
                try {
                    return DeepUnwrap.permissiveUnwrap((TemplateModel)((TemplateModel)v));
                }
                catch (TemplateModelException e) {
                    LOGGER.log(Level.WARNING, "", e);
                }
            }
            return v;
        }).collect(Collectors.toList());
    }

    private String processHtmlExtensions(Map<String, Object> model, List arguments) {
        try {
            List callbacks = GeoServerExtensions.extensions(HTMLExtensionCallback.class);
            StringBuilder sb = new StringBuilder();
            Request dr = (Request)Dispatcher.REQUEST.get();
            for (HTMLExtensionCallback callback : callbacks) {
                String html = callback.getExtension(dr, model, arguments);
                if (html == null) continue;
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(html);
            }
            return sb.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getBaseURL() {
        APIRequestInfo requestInfo = APIRequestInfo.get();
        if (requestInfo == null) {
            throw new IllegalArgumentException("Cannot extract base URL, APIRequestInfo is not set");
        }
        return requestInfo.getBaseURL();
    }

    protected void purgeIterators() {
        FreemarkerTemplateSupport.FC_FACTORY.purge();
    }
}

