/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ogcapi.Link;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.springframework.http.MediaType;

public class AbstractDocument {
    protected String id;
    protected String htmlTitle;
    protected final List<Link> links = new ArrayList<Link>();

    public void addLink(Link link) {
        this.links.add(link);
    }

    @JacksonXmlProperty(namespace="http://www.w3.org/2005/Atom", localName="link")
    @JacksonXmlElementWrapper(useWrapping=false)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<Link> getLinks() {
        return this.links;
    }

    public String getLinkUrl(String classification, String type) {
        return this.links.stream().filter(l -> Objects.equals(classification, l.getClassification())).filter(l -> type.equals(l.getType())).map(l -> l.getHref()).findFirst().orElse(null);
    }

    public List<Link> getLinksExcept(String classification, String excludedType) {
        return this.links.stream().filter(l -> classification == null || Objects.equals(classification, l.getClassification())).filter(l -> excludedType == null || !excludedType.equals(l.getType())).collect(Collectors.toList());
    }

    public final void addLinksFor(String path, Class<?> responseType, String titlePrefix, String classification, BiConsumer<MediaType, Link> linkUpdater, String rel) {
        List<Link> links = APIRequestInfo.get().getLinksFor(path, responseType, titlePrefix, classification, linkUpdater, rel, true);
        this.links.addAll(links);
    }

    protected final void addSelfLinks(String path) {
        this.addSelfLinks(path, MediaType.APPLICATION_JSON);
    }

    protected final void addSelfLinks(String path, MediaType defaultFormat) {
        APIRequestInfo requestInfo = APIRequestInfo.get();
        String baseUrl = requestInfo.getBaseURL();
        boolean firstSelf = true;
        for (MediaType format : requestInfo.getProducibleMediaTypes(this.getClass(), true)) {
            String apiUrl = ResponseUtils.buildURL((String)baseUrl, (String)path, Collections.singletonMap("f", format.toString()), (URLMangler.URLType)URLMangler.URLType.SERVICE);
            String linkType = "alternate";
            String linkTitle = "This document as " + format;
            if (firstSelf && requestInfo.isFormatRequested(format, defaultFormat)) {
                linkType = "self";
                linkTitle = "This document";
            }
            this.links.add(new Link(apiUrl, linkType, format.toString(), linkTitle));
        }
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (boolean)false);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonIgnore
    public String getEncodedId() {
        if (this.id == null) {
            return null;
        }
        return ResponseUtils.urlEncode((String)this.id, (char[])new char[0]);
    }

    @JsonIgnore
    public String getHtmlId() {
        if (this.id == null) {
            return null;
        }
        return this.id.replace(":", "__");
    }

    @JsonIgnore
    public String getHtmlTitle() {
        return this.htmlTitle != null ? this.htmlTitle : (this.id != null ? this.id : "");
    }

    public void setHtmlTitle(String htmlTitle) {
        this.htmlTitle = htmlTitle;
    }
}

