/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.ogcapi.APIDispatcher;
import org.geoserver.ogcapi.Link;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class APIRequestInfo {
    List<MediaType> MEDIA_TYPE_ALL_LIST = Collections.singletonList(MediaType.ALL);
    public static final String KEY = "APIRequestInfo";
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    String baseURL;
    List<MediaType> requestedMediaTypes;
    APIDispatcher dispatcher;
    Object result;

    public APIRequestInfo(HttpServletRequest request, HttpServletResponse response, APIDispatcher dispatcher) {
        this.dispatcher = dispatcher;
        this.request = request;
        this.response = response;
        this.baseURL = ResponseUtils.baseURL((HttpServletRequest)request);
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    String buildURI(String base, String path) {
        if (path != null) {
            if (path.startsWith(".")) {
                if (base.endsWith("/")) {
                    base = base.substring(1);
                }
                path = base + path;
            } else {
                path = ResponseUtils.appendPath((String[])new String[]{base, path});
            }
        }
        return ResponseUtils.buildURL((String)this.baseURL, (String)path, null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
    }

    public static APIRequestInfo get() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            return null;
        }
        return (APIRequestInfo)requestAttributes.getAttribute(KEY, 0);
    }

    public Map<String, String> getSimpleQueryMap() {
        Map queryMap = this.request.getParameterMap();
        if (queryMap == null) {
            return null;
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry entry : queryMap.entrySet()) {
            String key = (String)entry.getKey();
            Arrays.stream((String[])entry.getValue()).filter(v -> v != null && !v.isEmpty()).findFirst().ifPresent(v -> result.put(key, (String)v));
        }
        return result;
    }

    static void set(APIRequestInfo requestInfo) {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            throw new IllegalStateException("Request attributes are not set");
        }
        requestAttributes.setAttribute(KEY, (Object)requestInfo, 0);
    }

    public List<MediaType> getRequestedMediaTypes() {
        return this.requestedMediaTypes;
    }

    void setRequestedMediaTypes(List<MediaType> requestedMediaTypes) {
        this.requestedMediaTypes = requestedMediaTypes;
    }

    public List<HttpMessageConverter<?>> getConverters() {
        return this.dispatcher.getConverters();
    }

    public Collection<MediaType> getProducibleMediaTypes(Class<?> responseType, boolean addHTML) {
        return this.dispatcher.getProducibleMediaTypes(responseType, addHTML);
    }

    public boolean isAnyMediaTypeAccepted() {
        return this.requestedMediaTypes == null || ContentNegotiationManager.MEDIA_TYPE_ALL_LIST.equals(this.requestedMediaTypes);
    }

    public boolean isFormatRequested(MediaType mediaType, MediaType defaultMediaType) {
        if (this.requestedMediaTypes == null) {
            return false;
        }
        if (this.MEDIA_TYPE_ALL_LIST.equals(this.requestedMediaTypes) && defaultMediaType != null && defaultMediaType.isCompatibleWith(mediaType)) {
            return true;
        }
        return this.requestedMediaTypes.stream().filter(mt -> !mt.equals((Object)MediaType.ALL)).anyMatch(curr -> mediaType.isCompatibleWith(curr));
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public List<Link> getLinksFor(String path, Class<?> responseType, String titlePrefix, String classification, BiConsumer<MediaType, Link> linkUpdater, String rel, boolean includeHTML) {
        ArrayList<Link> result = new ArrayList<Link>();
        for (MediaType mediaType : APIRequestInfo.get().getProducibleMediaTypes(responseType, includeHTML)) {
            String format = mediaType.toString();
            Map<String, String> params = Collections.singletonMap("f", format);
            String url = ResponseUtils.buildURL((String)this.baseURL, (String)path, params, (URLMangler.URLType)URLMangler.URLType.SERVICE);
            String linkTitle = titlePrefix + format;
            Link link = new Link(url, rel, format, linkTitle);
            link.setClassification(classification);
            if (linkUpdater != null) {
                linkUpdater.accept(mediaType, link);
            }
            result.add(link);
        }
        return result;
    }

    public String getServiceLandingPage() {
        return Optional.ofNullable((Request)Dispatcher.REQUEST.get()).map(r -> r.getServiceDescriptor()).map(sd -> sd.getService()).map(s -> s.getClass()).map(c -> APIDispatcher.getApiServiceAnnotation(c)).map(a -> a.landingPage()).orElseThrow(() -> new RuntimeException("Could not find a service base URL at this stage, maybe the service has not been dispatched yet"));
    }

    public String getRequestPath() {
        String pathInfo = this.request.getPathInfo();
        String servletPath = this.request.getServletPath();
        return ResponseUtils.appendPath((String[])new String[]{servletPath, pathInfo});
    }

    public Object getResult() {
        return this.result;
    }

    void setResult(Object result) {
        this.result = result;
    }
}

