/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import org.geoserver.ogcapi.InvalidParameterValueException;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FilterFactoryImpl;
import org.geotools.filter.spatial.DefaultCRSFilterVisitor;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.cqljson.CQLJsonCompiler;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class APIFilterParser {
    private static final FilterFactory2 FF = CommonFactoryFinder.getFilterFactory2();
    public static String CQL_TEXT = "cql-text";
    public static String CQL_JSON = "cql-json";

    public Filter parse(String filter, String filterLang) {
        return this.parse(filter, filterLang, null);
    }

    public Filter parse(String filter, String filterLang, String filterCRS) {
        if (filter == null) {
            return null;
        }
        DefaultGeographicCRS queryCRS = DefaultGeographicCRS.WGS84;
        if (filterCRS != null) {
            try {
                queryCRS = CRS.decode((String)filterCRS);
            }
            catch (FactoryException e) {
                throw new InvalidParameterValueException(e.getMessage(), e);
            }
        }
        if (filterLang != null && !filterLang.equals(CQL_TEXT) && !filterLang.equals(CQL_JSON)) {
            throw new InvalidParameterValueException("Only supported filter-lang options at the moment are " + CQL_TEXT + " and " + CQL_JSON + " but '" + filterLang + "' was found instead");
        }
        try {
            Filter parsedFilter = null;
            if (filterLang == null || filterLang.equals(CQL_TEXT)) {
                parsedFilter = ECQL.toFilter((String)filter);
            } else if (filterLang.equals(CQL_JSON)) {
                CQLJsonCompiler cqlJsonCompiler = new CQLJsonCompiler(filter, (FilterFactory2)new FilterFactoryImpl());
                cqlJsonCompiler.compileFilter();
                parsedFilter = cqlJsonCompiler.getFilter();
            }
            if (parsedFilter != null) {
                DefaultCRSFilterVisitor crsDefaulter = new DefaultCRSFilterVisitor(FF, (CoordinateReferenceSystem)queryCRS);
                parsedFilter = (Filter)parsedFilter.accept((FilterVisitor)crsDefaulter, null);
                return parsedFilter;
            }
            return null;
        }
        catch (CQLException e) {
            throw new InvalidParameterValueException(e.getMessage(), e);
        }
    }
}

