/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import org.springframework.http.HttpStatus;

public class APIException
extends RuntimeException {
    private final HttpStatus status;
    private final String code;

    public APIException(String code, String body, HttpStatus status) {
        super(body);
        this.status = status;
        this.code = code;
    }

    public APIException(String code, String body, HttpStatus status, Throwable t) {
        super(body, t);
        this.status = status;
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public HttpStatus getStatus() {
        return this.status;
    }

    @Override
    public String toString() {
        String message;
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        if (this.status != null) {
            builder.append(" ");
            builder.append(this.status.value());
            builder.append(" ");
            builder.append(this.status.name());
        }
        if ((message = this.getLocalizedMessage()) != null) {
            builder.append(": ");
            builder.append(message);
        }
        return builder.toString();
    }
}

