/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.geoserver.ogcapi.APIException;
import org.geoserver.ogcapi.InvalidParameterValueException;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.platform.ServiceException;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.geometry.BoundingBox;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.http.HttpStatus;

public class APIBBoxParser {
    private static final FilterFactory2 FF = CommonFactoryFinder.getFilterFactory2();

    public static Filter toFilter(String bbox) throws FactoryException {
        return APIBBoxParser.toFilter(bbox, null);
    }

    public static Filter toFilter(double[] bbox, CoordinateReferenceSystem crs) throws FactoryException {
        ReferencedEnvelope[] parsed;
        if (bbox == null) {
            return Filter.INCLUDE;
        }
        if (bbox.length == 4) {
            parsed = APIBBoxParser.buildEnvelopes(bbox.length, bbox[0], bbox[1], 0.0, bbox[2], bbox[3], 0.0, crs);
        } else if (bbox.length == 6) {
            parsed = APIBBoxParser.buildEnvelopes(bbox.length, bbox[0], bbox[1], bbox[2], bbox[3], bbox[4], bbox[5], crs);
        } else {
            throw new APIException("InvalidParameterValue", "Bounding box array must have either 4 or 6 ordinates", HttpStatus.BAD_REQUEST);
        }
        return APIBBoxParser.toFilter(parsed);
    }

    public static Filter toFilter(String bbox, CoordinateReferenceSystem crs) throws FactoryException {
        if (bbox == null || bbox.trim().isEmpty()) {
            return Filter.INCLUDE;
        }
        ReferencedEnvelope[] parsed = APIBBoxParser.parse(bbox, crs);
        return APIBBoxParser.toFilter(parsed);
    }

    private static Filter toFilter(ReferencedEnvelope[] bboxes) {
        if (bboxes.length == 1) {
            return FF.bbox((Expression)FF.property(""), (BoundingBox)bboxes[0]);
        }
        if (bboxes instanceof ReferencedEnvelope[]) {
            List filters = Stream.of(bboxes).map(e -> FF.bbox((Expression)FF.property(""), (BoundingBox)e)).collect(Collectors.toList());
            return FF.or(filters);
        }
        throw new IllegalArgumentException("Could not understand parsed bbox " + Arrays.toString(bboxes));
    }

    public static ReferencedEnvelope[] parse(String value) throws FactoryException {
        return APIBBoxParser.parse(value, (CoordinateReferenceSystem)null);
    }

    public static ReferencedEnvelope[] parse(String value, String crs) throws FactoryException {
        return APIBBoxParser.parse(value, crs != null ? CRS.decode((String)crs, (boolean)true) : null);
    }

    public static ReferencedEnvelope[] parse(String value, CoordinateReferenceSystem crs) throws FactoryException {
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        List unparsed = KvpUtils.readFlat((String)value, (KvpUtils.Tokenizer)KvpUtils.INNER_DELIMETER);
        if (unparsed.size() < 4) {
            throw new IllegalArgumentException("Requested bounding box contains wrongnumber of coordinates (should have 4): " + unparsed.size());
        }
        int countco = 4;
        if (unparsed.size() == 6 || unparsed.size() == 7) {
            countco = 6;
        }
        double[] bbox = new double[countco];
        for (int i = 0; i < countco; ++i) {
            try {
                bbox[i] = Double.parseDouble((String)unparsed.get(i));
                continue;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Bounding box coordinate " + i + " is not parsable:" + unparsed.get(i));
            }
        }
        double minx = bbox[0];
        double miny = bbox[1];
        double minz = 0.0;
        double maxx = 0.0;
        double maxy = 0.0;
        double maxz = 0.0;
        if (countco == 6) {
            minz = bbox[2];
            maxx = bbox[3];
            maxy = bbox[4];
            maxz = bbox[5];
        } else {
            maxx = bbox[2];
            maxy = bbox[3];
        }
        return APIBBoxParser.buildEnvelopes(countco, minx, miny, minz, maxx, maxy, maxz, crs);
    }

    private static ReferencedEnvelope[] buildEnvelopes(int countco, double minx, double miny, double minz, double maxx, double maxy, double maxz, CoordinateReferenceSystem crs) throws NoSuchAuthorityCodeException, FactoryException {
        if (crs == null) {
            if (countco == 4) {
                crs = DefaultGeographicCRS.WGS84;
            } else if (countco == 6) {
                crs = DefaultGeographicCRS.WGS84_3D;
            }
        }
        if ((CRS.equalsIgnoreMetadata((Object)crs, (Object)DefaultGeographicCRS.WGS84) || CRS.equalsIgnoreMetadata((Object)crs, (Object)DefaultGeographicCRS.WGS84_3D)) && (minx = APIBBoxParser.rollLongitude(minx)) > (maxx = APIBBoxParser.rollLongitude(maxx))) {
            return new ReferencedEnvelope[]{APIBBoxParser.buildSingleEnvelope(countco, minx, miny, minz, 180.0, maxy, maxz, crs), APIBBoxParser.buildSingleEnvelope(countco, -180.0, miny, minz, maxx, maxy, maxz, crs)};
        }
        return new ReferencedEnvelope[]{APIBBoxParser.buildSingleEnvelope(countco, minx, miny, minz, maxx, maxy, maxz, crs)};
    }

    private static ReferencedEnvelope buildSingleEnvelope(int countco, double minx, double miny, double minz, double maxx, double maxy, double maxz, CoordinateReferenceSystem crs) {
        if (minx > maxx) {
            throw new ServiceException("illegal bbox, minX: " + minx + " is greater than maxX: " + maxx);
        }
        if (miny > maxy) {
            throw new ServiceException("illegal bbox, minY: " + miny + " is greater than maxY: " + maxy);
        }
        if (minz > maxz) {
            throw new ServiceException("illegal bbox, minZ: " + minz + " is greater than maxZ: " + maxz);
        }
        if (countco == 6) {
            return new ReferencedEnvelope3D(minx, maxx, miny, maxy, minz, maxz, crs);
        }
        if (crs == null || crs.getCoordinateSystem().getDimension() == 2) {
            return new ReferencedEnvelope(minx, maxx, miny, maxy, crs);
        }
        if (crs.getCoordinateSystem().getDimension() == 3) {
            return new ReferencedEnvelope3D(minx, maxx, miny, maxy, -1.7976931348623157E308, Double.MAX_VALUE, crs);
        }
        throw new InvalidParameterValueException("Unexpected BBOX, can only handle 2D or 3D ones");
    }

    private static double rollLongitude(double x) {
        double mod = (x + 180.0) % 360.0;
        if (mod == 0.0) {
            return x > 0.0 ? 180.0 : -180.0;
        }
        return mod - 180.0;
    }

    public static Geometry toGeometry(String spec) throws FactoryException {
        ReferencedEnvelope[] parse = APIBBoxParser.parse(spec);
        List<Polygon> polygons = Arrays.stream(parse).map(bbox -> JTS.toGeometry((ReferencedEnvelope)bbox)).collect(Collectors.toList());
        if (polygons.size() == 1) {
            return (Geometry)polygons.get(0);
        }
        return ((Polygon)polygons.get(0)).getFactory().createMultiPolygon(polygons.toArray(new Polygon[polygons.size()]));
    }
}

